// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.EmailTemplateContent
import aws.sdk.kotlin.services.sesv2.model.GetEmailTemplateResponse
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetEmailTemplateOperationDeserializer: HttpDeserialize<GetEmailTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEmailTemplateResponse {
        if (!response.status.isSuccess()) {
            throwGetEmailTemplateError(context, response)
        }
        val builder = GetEmailTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEmailTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEmailTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEmailTemplateOperationBody(builder: GetEmailTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TEMPLATECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TemplateContent"))
    val TEMPLATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TEMPLATECONTENT_DESCRIPTOR)
        field(TEMPLATENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TEMPLATECONTENT_DESCRIPTOR.index -> builder.templateContent = deserializeEmailTemplateContentDocument(deserializer)
                TEMPLATENAME_DESCRIPTOR.index -> builder.templateName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
