// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.DkimAttributes
import aws.sdk.kotlin.services.sesv2.model.GetEmailIdentityResponse
import aws.sdk.kotlin.services.sesv2.model.IdentityType
import aws.sdk.kotlin.services.sesv2.model.MailFromAttributes
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.sdk.kotlin.services.sesv2.model.Tag
import aws.sdk.kotlin.services.sesv2.model.VerificationStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetEmailIdentityOperationDeserializer: HttpDeserialize<GetEmailIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEmailIdentityResponse {
        if (!response.status.isSuccess()) {
            throwGetEmailIdentityError(context, response)
        }
        val builder = GetEmailIdentityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEmailIdentityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEmailIdentityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEmailIdentityOperationBody(builder: GetEmailIdentityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATIONSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationSetName"))
    val DKIMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DkimAttributes"))
    val FEEDBACKFORWARDINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("FeedbackForwardingStatus"))
    val IDENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IdentityType"))
    val MAILFROMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MailFromAttributes"))
    val POLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Policies"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VERIFICATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VerificationStatus"))
    val VERIFIEDFORSENDINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("VerifiedForSendingStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONSETNAME_DESCRIPTOR)
        field(DKIMATTRIBUTES_DESCRIPTOR)
        field(FEEDBACKFORWARDINGSTATUS_DESCRIPTOR)
        field(IDENTITYTYPE_DESCRIPTOR)
        field(MAILFROMATTRIBUTES_DESCRIPTOR)
        field(POLICIES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERIFICATIONSTATUS_DESCRIPTOR)
        field(VERIFIEDFORSENDINGSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATIONSETNAME_DESCRIPTOR.index -> builder.configurationSetName = deserializeString()
                DKIMATTRIBUTES_DESCRIPTOR.index -> builder.dkimAttributes = deserializeDkimAttributesDocument(deserializer)
                FEEDBACKFORWARDINGSTATUS_DESCRIPTOR.index -> builder.feedbackForwardingStatus = deserializeBoolean()
                IDENTITYTYPE_DESCRIPTOR.index -> builder.identityType = deserializeString().let { IdentityType.fromValue(it) }
                MAILFROMATTRIBUTES_DESCRIPTOR.index -> builder.mailFromAttributes = deserializeMailFromAttributesDocument(deserializer)
                POLICIES_DESCRIPTOR.index -> builder.policies =
                    deserializer.deserializeMap(POLICIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VERIFICATIONSTATUS_DESCRIPTOR.index -> builder.verificationStatus = deserializeString().let { VerificationStatus.fromValue(it) }
                VERIFIEDFORSENDINGSTATUS_DESCRIPTOR.index -> builder.verifiedForSendingStatus = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
