// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.DeliverabilityTestReport
import aws.sdk.kotlin.services.sesv2.model.GetDeliverabilityTestReportResponse
import aws.sdk.kotlin.services.sesv2.model.IspPlacement
import aws.sdk.kotlin.services.sesv2.model.PlacementStatistics
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.sdk.kotlin.services.sesv2.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDeliverabilityTestReportOperationDeserializer: HttpDeserialize<GetDeliverabilityTestReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDeliverabilityTestReportResponse {
        if (!response.status.isSuccess()) {
            throwGetDeliverabilityTestReportError(context, response)
        }
        val builder = GetDeliverabilityTestReportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDeliverabilityTestReportOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDeliverabilityTestReportError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeliverabilityTestReportOperationBody(builder: GetDeliverabilityTestReportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELIVERABILITYTESTREPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeliverabilityTestReport"))
    val ISPPLACEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("IspPlacements"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val OVERALLPLACEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverallPlacement"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELIVERABILITYTESTREPORT_DESCRIPTOR)
        field(ISPPLACEMENTS_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(OVERALLPLACEMENT_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELIVERABILITYTESTREPORT_DESCRIPTOR.index -> builder.deliverabilityTestReport = deserializeDeliverabilityTestReportDocument(deserializer)
                ISPPLACEMENTS_DESCRIPTOR.index -> builder.ispPlacements =
                    deserializer.deserializeList(ISPPLACEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<IspPlacement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIspPlacementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                OVERALLPLACEMENT_DESCRIPTOR.index -> builder.overallPlacement = deserializePlacementStatisticsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
