// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.GetContactResponse
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.sdk.kotlin.services.sesv2.model.TopicPreference
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetContactOperationDeserializer: HttpDeserialize<GetContactResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetContactResponse {
        if (!response.status.isSuccess()) {
            throwGetContactError(context, response)
        }
        val builder = GetContactResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetContactOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetContactError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetContactOperationBody(builder: GetContactResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTRIBUTESDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AttributesData"))
    val CONTACTLISTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactListName"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val EMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EmailAddress"))
    val LASTUPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTimestamp"))
    val TOPICDEFAULTPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TopicDefaultPreferences"))
    val TOPICPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TopicPreferences"))
    val UNSUBSCRIBEALL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UnsubscribeAll"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTESDATA_DESCRIPTOR)
        field(CONTACTLISTNAME_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(EMAILADDRESS_DESCRIPTOR)
        field(LASTUPDATEDTIMESTAMP_DESCRIPTOR)
        field(TOPICDEFAULTPREFERENCES_DESCRIPTOR)
        field(TOPICPREFERENCES_DESCRIPTOR)
        field(UNSUBSCRIBEALL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTRIBUTESDATA_DESCRIPTOR.index -> builder.attributesData = deserializeString()
                CONTACTLISTNAME_DESCRIPTOR.index -> builder.contactListName = deserializeString()
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                EMAILADDRESS_DESCRIPTOR.index -> builder.emailAddress = deserializeString()
                LASTUPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.lastUpdatedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                TOPICDEFAULTPREFERENCES_DESCRIPTOR.index -> builder.topicDefaultPreferences =
                    deserializer.deserializeList(TOPICDEFAULTPREFERENCES_DESCRIPTOR) {
                        val col0 = mutableListOf<TopicPreference>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTopicPreferenceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOPICPREFERENCES_DESCRIPTOR.index -> builder.topicPreferences =
                    deserializer.deserializeList(TOPICPREFERENCES_DESCRIPTOR) {
                        val col0 = mutableListOf<TopicPreference>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTopicPreferenceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNSUBSCRIBEALL_DESCRIPTOR.index -> builder.unsubscribeAll = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
