// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.services.sesv2.model.CreateContactRequest
import aws.sdk.kotlin.services.sesv2.model.TopicPreference
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateContactOperationSerializer: HttpSerialize<CreateContactRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateContactRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "v2",
                "email",
                "contact-lists",
                "${input.contactListName}".encodeLabel(),
                "contacts",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateContactOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateContactOperationBody(context: ExecutionContext, input: CreateContactRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTESDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AttributesData"))
    val EMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EmailAddress"))
    val TOPICPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TopicPreferences"))
    val UNSUBSCRIBEALL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UnsubscribeAll"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTESDATA_DESCRIPTOR)
        field(EMAILADDRESS_DESCRIPTOR)
        field(TOPICPREFERENCES_DESCRIPTOR)
        field(UNSUBSCRIBEALL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributesData?.let { field(ATTRIBUTESDATA_DESCRIPTOR, it) }
        input.emailAddress?.let { field(EMAILADDRESS_DESCRIPTOR, it) }
        if (input.topicPreferences != null) {
            listField(TOPICPREFERENCES_DESCRIPTOR) {
                for (el0 in input.topicPreferences) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTopicPreferenceDocument))
                }
            }
        }
        if (input.unsubscribeAll != false) field(UNSUBSCRIBEALL_DESCRIPTOR, input.unsubscribeAll)
    }
    return serializer.toByteArray()
}
