// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Represents a request to list the existing recommendations for your account.
 */
public class ListRecommendationsRequest private constructor(builder: Builder) {
    /**
     * Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of `STATUS` and `IMPACT` or `STATUS` and `TYPE`
     */
    public val filter: Map<String, String>? = builder.filter
    /**
     * A token returned from a previous call to `ListRecommendations` to indicate the position in the list of recommendations.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The number of results to show in a single call to `ListRecommendations`. If the number of results is larger than the number you specified in this parameter, then the response includes a `NextToken` element, which you can use to obtain additional results.
     *
     * The value you specify has to be at least 1, and can be no more than 100.
     */
    public val pageSize: kotlin.Int? = builder.pageSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.ListRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRecommendationsRequest(")
        append("filter=$filter,")
        append("nextToken=$nextToken,")
        append("pageSize=$pageSize)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (pageSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRecommendationsRequest

        if (filter != other.filter) return false
        if (nextToken != other.nextToken) return false
        if (pageSize != other.pageSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.ListRecommendationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of `STATUS` and `IMPACT` or `STATUS` and `TYPE`
         */
        public var filter: Map<String, String>? = null
        /**
         * A token returned from a previous call to `ListRecommendations` to indicate the position in the list of recommendations.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The number of results to show in a single call to `ListRecommendations`. If the number of results is larger than the number you specified in this parameter, then the response includes a `NextToken` element, which you can use to obtain additional results.
         *
         * The value you specify has to be at least 1, and can be no more than 100.
         */
        public var pageSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.ListRecommendationsRequest) : this() {
            this.filter = x.filter
            this.nextToken = x.nextToken
            this.pageSize = x.pageSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.ListRecommendationsRequest = ListRecommendationsRequest(this)
    }
}
