// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Represents a request to list the email templates present in your Amazon SES account in the current Amazon Web Services Region. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
 */
public class ListEmailTemplatesRequest private constructor(builder: Builder) {
    /**
     * A token returned from a previous call to `ListEmailTemplates` to indicate the position in the list of email templates.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The number of results to show in a single call to `ListEmailTemplates`. If the number of results is larger than the number you specified in this parameter, then the response includes a `NextToken` element, which you can use to obtain additional results.
     *
     * The value you specify has to be at least 1, and can be no more than 10.
     */
    public val pageSize: kotlin.Int? = builder.pageSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.ListEmailTemplatesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEmailTemplatesRequest(")
        append("nextToken=$nextToken,")
        append("pageSize=$pageSize)")
    }

    override fun hashCode(): kotlin.Int {
        var result = nextToken?.hashCode() ?: 0
        result = 31 * result + (pageSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEmailTemplatesRequest

        if (nextToken != other.nextToken) return false
        if (pageSize != other.pageSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.ListEmailTemplatesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A token returned from a previous call to `ListEmailTemplates` to indicate the position in the list of email templates.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The number of results to show in a single call to `ListEmailTemplates`. If the number of results is larger than the number you specified in this parameter, then the response includes a `NextToken` element, which you can use to obtain additional results.
         *
         * The value you specify has to be at least 1, and can be no more than 10.
         */
        public var pageSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.ListEmailTemplatesRequest) : this() {
            this.nextToken = x.nextToken
            this.pageSize = x.pageSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.ListEmailTemplatesRequest = ListEmailTemplatesRequest(this)
    }
}
