// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Information about an email identity.
 */
public class IdentityInfo private constructor(builder: Builder) {
    /**
     * The address or domain of the identity.
     */
    public val identityName: kotlin.String? = builder.identityName
    /**
     * The email identity type. Note: the `MANAGED_DOMAIN` type is not supported for email identity types.
     */
    public val identityType: aws.sdk.kotlin.services.sesv2.model.IdentityType? = builder.identityType
    /**
     * Indicates whether or not you can send email from the identity.
     *
     * An *identity* is an email address or domain that you send email from. Before you can send email from an identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send email from that identity.
     */
    public val sendingEnabled: kotlin.Boolean = builder.sendingEnabled
    /**
     * The verification status of the identity. The status can be one of the following:
     * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet been able to verify the identity.
     * + `SUCCESS` – The verification process completed successfully.
     * + `FAILED` – The verification process failed.
     * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the verification status of the identity.
     * + `NOT_STARTED` – The verification process hasn't been initiated for the identity.
     */
    public val verificationStatus: aws.sdk.kotlin.services.sesv2.model.VerificationStatus? = builder.verificationStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.IdentityInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityInfo(")
        append("identityName=$identityName,")
        append("identityType=$identityType,")
        append("sendingEnabled=$sendingEnabled,")
        append("verificationStatus=$verificationStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityName?.hashCode() ?: 0
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (sendingEnabled.hashCode())
        result = 31 * result + (verificationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityInfo

        if (identityName != other.identityName) return false
        if (identityType != other.identityType) return false
        if (sendingEnabled != other.sendingEnabled) return false
        if (verificationStatus != other.verificationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.IdentityInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The address or domain of the identity.
         */
        public var identityName: kotlin.String? = null
        /**
         * The email identity type. Note: the `MANAGED_DOMAIN` type is not supported for email identity types.
         */
        public var identityType: aws.sdk.kotlin.services.sesv2.model.IdentityType? = null
        /**
         * Indicates whether or not you can send email from the identity.
         *
         * An *identity* is an email address or domain that you send email from. Before you can send email from an identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send email from that identity.
         */
        public var sendingEnabled: kotlin.Boolean = false
        /**
         * The verification status of the identity. The status can be one of the following:
         * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet been able to verify the identity.
         * + `SUCCESS` – The verification process completed successfully.
         * + `FAILED` – The verification process failed.
         * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the verification status of the identity.
         * + `NOT_STARTED` – The verification process hasn't been initiated for the identity.
         */
        public var verificationStatus: aws.sdk.kotlin.services.sesv2.model.VerificationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.IdentityInfo) : this() {
            this.identityName = x.identityName
            this.identityType = x.identityType
            this.sendingEnabled = x.sendingEnabled
            this.verificationStatus = x.verificationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.IdentityInfo = IdentityInfo(this)
    }
}
