// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * In the Amazon SES API v2, *events* include message sends, deliveries, opens, clicks, bounces, complaints and delivery delays. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
 */
public class EventDestination private constructor(builder: Builder) {
    /**
     * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
     */
    public val cloudWatchDestination: aws.sdk.kotlin.services.sesv2.model.CloudWatchDestination? = builder.cloudWatchDestination
    /**
     * If `true`, the event destination is enabled. When the event destination is enabled, the specified event types are sent to the destinations in this `EventDestinationDefinition`.
     *
     * If `false`, the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
     */
    public val kinesisFirehoseDestination: aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination? = builder.kinesisFirehoseDestination
    /**
     * The types of events that Amazon SES sends to the specified event destinations.
     */
    public val matchingEventTypes: List<EventType>? = builder.matchingEventTypes
    /**
     * A name that identifies the event destination.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An object that defines an Amazon Pinpoint project destination for email events. You can send email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging dashboards that are built in to Amazon Pinpoint. For more information, see [Transactional Messaging Charts](https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html) in the *Amazon Pinpoint User Guide*.
     */
    public val pinpointDestination: aws.sdk.kotlin.services.sesv2.model.PinpointDestination? = builder.pinpointDestination
    /**
     * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.
     */
    public val snsDestination: aws.sdk.kotlin.services.sesv2.model.SnsDestination? = builder.snsDestination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.EventDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventDestination(")
        append("cloudWatchDestination=$cloudWatchDestination,")
        append("enabled=$enabled,")
        append("kinesisFirehoseDestination=$kinesisFirehoseDestination,")
        append("matchingEventTypes=$matchingEventTypes,")
        append("name=$name,")
        append("pinpointDestination=$pinpointDestination,")
        append("snsDestination=$snsDestination)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchDestination?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (kinesisFirehoseDestination?.hashCode() ?: 0)
        result = 31 * result + (matchingEventTypes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pinpointDestination?.hashCode() ?: 0)
        result = 31 * result + (snsDestination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventDestination

        if (cloudWatchDestination != other.cloudWatchDestination) return false
        if (enabled != other.enabled) return false
        if (kinesisFirehoseDestination != other.kinesisFirehoseDestination) return false
        if (matchingEventTypes != other.matchingEventTypes) return false
        if (name != other.name) return false
        if (pinpointDestination != other.pinpointDestination) return false
        if (snsDestination != other.snsDestination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.EventDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.
         */
        public var cloudWatchDestination: aws.sdk.kotlin.services.sesv2.model.CloudWatchDestination? = null
        /**
         * If `true`, the event destination is enabled. When the event destination is enabled, the specified event types are sent to the destinations in this `EventDestinationDefinition`.
         *
         * If `false`, the event destination is disabled. When the event destination is disabled, events aren't sent to the specified destinations.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
         */
        public var kinesisFirehoseDestination: aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination? = null
        /**
         * The types of events that Amazon SES sends to the specified event destinations.
         */
        public var matchingEventTypes: List<EventType>? = null
        /**
         * A name that identifies the event destination.
         */
        public var name: kotlin.String? = null
        /**
         * An object that defines an Amazon Pinpoint project destination for email events. You can send email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging dashboards that are built in to Amazon Pinpoint. For more information, see [Transactional Messaging Charts](https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html) in the *Amazon Pinpoint User Guide*.
         */
        public var pinpointDestination: aws.sdk.kotlin.services.sesv2.model.PinpointDestination? = null
        /**
         * An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.
         */
        public var snsDestination: aws.sdk.kotlin.services.sesv2.model.SnsDestination? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.EventDestination) : this() {
            this.cloudWatchDestination = x.cloudWatchDestination
            this.enabled = x.enabled
            this.kinesisFirehoseDestination = x.kinesisFirehoseDestination
            this.matchingEventTypes = x.matchingEventTypes
            this.name = x.name
            this.pinpointDestination = x.pinpointDestination
            this.snsDestination = x.snsDestination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.EventDestination = EventDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.CloudWatchDestination] inside the given [block]
         */
        public fun cloudWatchDestination(block: aws.sdk.kotlin.services.sesv2.model.CloudWatchDestination.Builder.() -> kotlin.Unit) {
            this.cloudWatchDestination = aws.sdk.kotlin.services.sesv2.model.CloudWatchDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination] inside the given [block]
         */
        public fun kinesisFirehoseDestination(block: aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseDestination = aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.PinpointDestination] inside the given [block]
         */
        public fun pinpointDestination(block: aws.sdk.kotlin.services.sesv2.model.PinpointDestination.Builder.() -> kotlin.Unit) {
            this.pinpointDestination = aws.sdk.kotlin.services.sesv2.model.PinpointDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.SnsDestination] inside the given [block]
         */
        public fun snsDestination(block: aws.sdk.kotlin.services.sesv2.model.SnsDestination.Builder.() -> kotlin.Unit) {
            this.snsDestination = aws.sdk.kotlin.services.sesv2.model.SnsDestination.invoke(block)
        }
    }
}
