// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import kotlin.collections.List

/**
 * The DKIM authentication status of the identity. The status can be one of the following:
 * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM records in the DNS configuration for the domain.
 * + `SUCCESS` – The verification process completed successfully.
 * + `FAILED` – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.
 * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.
 * + `NOT_STARTED` – The DKIM verification process hasn't been initiated for the domain.
 */
public sealed class DkimStatus {

    public abstract val value: kotlin.String

    public object Failed : aws.sdk.kotlin.services.sesv2.model.DkimStatus() {
        override val value: kotlin.String = "FAILED"
        override fun toString(): kotlin.String = value
    }

    public object NotStarted : aws.sdk.kotlin.services.sesv2.model.DkimStatus() {
        override val value: kotlin.String = "NOT_STARTED"
        override fun toString(): kotlin.String = value
    }

    public object Pending : aws.sdk.kotlin.services.sesv2.model.DkimStatus() {
        override val value: kotlin.String = "PENDING"
        override fun toString(): kotlin.String = value
    }

    public object Success : aws.sdk.kotlin.services.sesv2.model.DkimStatus() {
        override val value: kotlin.String = "SUCCESS"
        override fun toString(): kotlin.String = value
    }

    public object TemporaryFailure : aws.sdk.kotlin.services.sesv2.model.DkimStatus() {
        override val value: kotlin.String = "TEMPORARY_FAILURE"
        override fun toString(): kotlin.String = value
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.sesv2.model.DkimStatus() {
        override fun toString(): kotlin.String = value
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(str: kotlin.String): aws.sdk.kotlin.services.sesv2.model.DkimStatus = when(str) {
            "FAILED" -> Failed
            "NOT_STARTED" -> NotStarted
            "PENDING" -> Pending
            "SUCCESS" -> Success
            "TEMPORARY_FAILURE" -> TemporaryFailure
            else -> SdkUnknown(str)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.sesv2.model.DkimStatus> = listOf(
            Failed,
            NotStarted,
            Pending,
            Success,
            TemporaryFailure
        )
    }
}
