// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Represents a request to create a custom verification email template.
 */
public class CreateCustomVerificationEmailTemplateRequest private constructor(builder: Builder) {
    /**
     * The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.
     */
    public val failureRedirectionUrl: kotlin.String? = builder.failureRedirectionUrl
    /**
     * The email address that the custom verification email is sent from.
     */
    public val fromEmailAddress: kotlin.String? = builder.fromEmailAddress
    /**
     * The URL that the recipient of the verification email is sent to if his or her address is successfully verified.
     */
    public val successRedirectionUrl: kotlin.String? = builder.successRedirectionUrl
    /**
     * The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see [Custom verification email frequently asked questions](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom-faq) in the *Amazon SES Developer Guide*.
     */
    public val templateContent: kotlin.String? = builder.templateContent
    /**
     * The name of the custom verification email template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The subject line of the custom verification email.
     */
    public val templateSubject: kotlin.String? = builder.templateSubject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomVerificationEmailTemplateRequest(")
        append("failureRedirectionUrl=$failureRedirectionUrl,")
        append("fromEmailAddress=$fromEmailAddress,")
        append("successRedirectionUrl=$successRedirectionUrl,")
        append("templateContent=$templateContent,")
        append("templateName=$templateName,")
        append("templateSubject=$templateSubject)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureRedirectionUrl?.hashCode() ?: 0
        result = 31 * result + (fromEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (successRedirectionUrl?.hashCode() ?: 0)
        result = 31 * result + (templateContent?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (templateSubject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomVerificationEmailTemplateRequest

        if (failureRedirectionUrl != other.failureRedirectionUrl) return false
        if (fromEmailAddress != other.fromEmailAddress) return false
        if (successRedirectionUrl != other.successRedirectionUrl) return false
        if (templateContent != other.templateContent) return false
        if (templateName != other.templateName) return false
        if (templateSubject != other.templateSubject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.
         */
        public var failureRedirectionUrl: kotlin.String? = null
        /**
         * The email address that the custom verification email is sent from.
         */
        public var fromEmailAddress: kotlin.String? = null
        /**
         * The URL that the recipient of the verification email is sent to if his or her address is successfully verified.
         */
        public var successRedirectionUrl: kotlin.String? = null
        /**
         * The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see [Custom verification email frequently asked questions](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom-faq) in the *Amazon SES Developer Guide*.
         */
        public var templateContent: kotlin.String? = null
        /**
         * The name of the custom verification email template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The subject line of the custom verification email.
         */
        public var templateSubject: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest) : this() {
            this.failureRedirectionUrl = x.failureRedirectionUrl
            this.fromEmailAddress = x.fromEmailAddress
            this.successRedirectionUrl = x.successRedirectionUrl
            this.templateContent = x.templateContent
            this.templateName = x.templateName
            this.templateSubject = x.templateSubject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest = CreateCustomVerificationEmailTemplateRequest(this)
    }
}
