// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.serde

import aws.sdk.kotlin.services.sesv2.model.TopicPreference
import aws.sdk.kotlin.services.sesv2.model.UpdateContactRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateContactOperationSerializer: HttpSerialize<UpdateContactRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateContactRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.contactListName) { "contactListName is bound to the URI and must not be null" }
            requireNotNull(input.emailAddress) { "emailAddress is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("email"))
                add(PercentEncoding.Path.encode("contact-lists"))
                add(PercentEncoding.SmithyLabel.encode("${input.contactListName}"))
                add(PercentEncoding.Path.encode("contacts"))
                add(PercentEncoding.SmithyLabel.encode("${input.emailAddress}"))
            }
        }

        val payload = serializeUpdateContactOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateContactOperationBody(context: ExecutionContext, input: UpdateContactRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTESDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AttributesData"))
    val TOPICPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TopicPreferences"))
    val UNSUBSCRIBEALL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UnsubscribeAll"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTESDATA_DESCRIPTOR)
        field(TOPICPREFERENCES_DESCRIPTOR)
        field(UNSUBSCRIBEALL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributesData?.let { field(ATTRIBUTESDATA_DESCRIPTOR, it) }
        if (input.topicPreferences != null) {
            listField(TOPICPREFERENCES_DESCRIPTOR) {
                for (el0 in input.topicPreferences) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTopicPreferenceDocument))
                }
            }
        }
        input.unsubscribeAll?.let { field(UNSUBSCRIBEALL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
