// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.serde

import aws.sdk.kotlin.services.sesv2.model.EmailInsights
import aws.sdk.kotlin.services.sesv2.model.GetMessageInsightsResponse
import aws.sdk.kotlin.services.sesv2.model.MessageTag
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetMessageInsightsOperationDeserializer: HttpDeserialize<GetMessageInsightsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetMessageInsightsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMessageInsightsError(context, call)
        }
        val builder = GetMessageInsightsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMessageInsightsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetMessageInsightsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMessageInsightsOperationBody(builder: GetMessageInsightsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EMAILTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EmailTags"))
    val FROMEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FromEmailAddress"))
    val INSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Insights"))
    val MESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MessageId"))
    val SUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Subject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EMAILTAGS_DESCRIPTOR)
        field(FROMEMAILADDRESS_DESCRIPTOR)
        field(INSIGHTS_DESCRIPTOR)
        field(MESSAGEID_DESCRIPTOR)
        field(SUBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EMAILTAGS_DESCRIPTOR.index -> builder.emailTags =
                    deserializer.deserializeList(EMAILTAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<MessageTag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMessageTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FROMEMAILADDRESS_DESCRIPTOR.index -> builder.fromEmailAddress = deserializeString()
                INSIGHTS_DESCRIPTOR.index -> builder.insights =
                    deserializer.deserializeList(INSIGHTS_DESCRIPTOR) {
                        val col0 = mutableListOf<EmailInsights>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEmailInsightsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MESSAGEID_DESCRIPTOR.index -> builder.messageId = deserializeString()
                SUBJECT_DESCRIPTOR.index -> builder.subject = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
