// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.serde

import aws.sdk.kotlin.services.sesv2.model.FailureInfo
import aws.sdk.kotlin.services.sesv2.model.GetImportJobResponse
import aws.sdk.kotlin.services.sesv2.model.ImportDataSource
import aws.sdk.kotlin.services.sesv2.model.ImportDestination
import aws.sdk.kotlin.services.sesv2.model.JobStatus
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetImportJobOperationDeserializer: HttpDeserialize<GetImportJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetImportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetImportJobError(context, call)
        }
        val builder = GetImportJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetImportJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetImportJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetImportJobOperationBody(builder: GetImportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPLETEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletedTimestamp"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val FAILEDRECORDSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FailedRecordsCount"))
    val FAILUREINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FailureInfo"))
    val IMPORTDATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImportDataSource"))
    val IMPORTDESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImportDestination"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobStatus"))
    val PROCESSEDRECORDSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ProcessedRecordsCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPLETEDTIMESTAMP_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(FAILEDRECORDSCOUNT_DESCRIPTOR)
        field(FAILUREINFO_DESCRIPTOR)
        field(IMPORTDATASOURCE_DESCRIPTOR)
        field(IMPORTDESTINATION_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(PROCESSEDRECORDSCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPLETEDTIMESTAMP_DESCRIPTOR.index -> builder.completedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILEDRECORDSCOUNT_DESCRIPTOR.index -> builder.failedRecordsCount = deserializeInt()
                FAILUREINFO_DESCRIPTOR.index -> builder.failureInfo = deserializeFailureInfoDocument(deserializer)
                IMPORTDATASOURCE_DESCRIPTOR.index -> builder.importDataSource = deserializeImportDataSourceDocument(deserializer)
                IMPORTDESTINATION_DESCRIPTOR.index -> builder.importDestination = deserializeImportDestinationDocument(deserializer)
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { JobStatus.fromValue(it) }
                PROCESSEDRECORDSCOUNT_DESCRIPTOR.index -> builder.processedRecordsCount = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
