// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.serde

import aws.sdk.kotlin.services.sesv2.model.ExportDataSource
import aws.sdk.kotlin.services.sesv2.model.ExportDestination
import aws.sdk.kotlin.services.sesv2.model.ExportSourceType
import aws.sdk.kotlin.services.sesv2.model.ExportStatistics
import aws.sdk.kotlin.services.sesv2.model.FailureInfo
import aws.sdk.kotlin.services.sesv2.model.GetExportJobResponse
import aws.sdk.kotlin.services.sesv2.model.JobStatus
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetExportJobOperationDeserializer: HttpDeserialize<GetExportJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetExportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetExportJobError(context, call)
        }
        val builder = GetExportJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetExportJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetExportJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetExportJobOperationBody(builder: GetExportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPLETEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletedTimestamp"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val EXPORTDATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExportDataSource"))
    val EXPORTDESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExportDestination"))
    val EXPORTSOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ExportSourceType"))
    val FAILUREINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FailureInfo"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobStatus"))
    val STATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Statistics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPLETEDTIMESTAMP_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(EXPORTDATASOURCE_DESCRIPTOR)
        field(EXPORTDESTINATION_DESCRIPTOR)
        field(EXPORTSOURCETYPE_DESCRIPTOR)
        field(FAILUREINFO_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(STATISTICS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPLETEDTIMESTAMP_DESCRIPTOR.index -> builder.completedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                EXPORTDATASOURCE_DESCRIPTOR.index -> builder.exportDataSource = deserializeExportDataSourceDocument(deserializer)
                EXPORTDESTINATION_DESCRIPTOR.index -> builder.exportDestination = deserializeExportDestinationDocument(deserializer)
                EXPORTSOURCETYPE_DESCRIPTOR.index -> builder.exportSourceType = deserializeString().let { ExportSourceType.fromValue(it) }
                FAILUREINFO_DESCRIPTOR.index -> builder.failureInfo = deserializeFailureInfoDocument(deserializer)
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { JobStatus.fromValue(it) }
                STATISTICS_DESCRIPTOR.index -> builder.statistics = deserializeExportStatisticsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
