// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.serde

import aws.sdk.kotlin.services.sesv2.model.DkimAttributes
import aws.sdk.kotlin.services.sesv2.model.GetEmailIdentityResponse
import aws.sdk.kotlin.services.sesv2.model.IdentityType
import aws.sdk.kotlin.services.sesv2.model.MailFromAttributes
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.sdk.kotlin.services.sesv2.model.Tag
import aws.sdk.kotlin.services.sesv2.model.VerificationInfo
import aws.sdk.kotlin.services.sesv2.model.VerificationStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetEmailIdentityOperationDeserializer: HttpDeserialize<GetEmailIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetEmailIdentityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEmailIdentityError(context, call)
        }
        val builder = GetEmailIdentityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEmailIdentityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetEmailIdentityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEmailIdentityOperationBody(builder: GetEmailIdentityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATIONSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationSetName"))
    val DKIMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DkimAttributes"))
    val FEEDBACKFORWARDINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("FeedbackForwardingStatus"))
    val IDENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IdentityType"))
    val MAILFROMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MailFromAttributes"))
    val POLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Policies"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VERIFICATIONINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VerificationInfo"))
    val VERIFICATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VerificationStatus"))
    val VERIFIEDFORSENDINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("VerifiedForSendingStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONSETNAME_DESCRIPTOR)
        field(DKIMATTRIBUTES_DESCRIPTOR)
        field(FEEDBACKFORWARDINGSTATUS_DESCRIPTOR)
        field(IDENTITYTYPE_DESCRIPTOR)
        field(MAILFROMATTRIBUTES_DESCRIPTOR)
        field(POLICIES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERIFICATIONINFO_DESCRIPTOR)
        field(VERIFICATIONSTATUS_DESCRIPTOR)
        field(VERIFIEDFORSENDINGSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATIONSETNAME_DESCRIPTOR.index -> builder.configurationSetName = deserializeString()
                DKIMATTRIBUTES_DESCRIPTOR.index -> builder.dkimAttributes = deserializeDkimAttributesDocument(deserializer)
                FEEDBACKFORWARDINGSTATUS_DESCRIPTOR.index -> builder.feedbackForwardingStatus = deserializeBoolean()
                IDENTITYTYPE_DESCRIPTOR.index -> builder.identityType = deserializeString().let { IdentityType.fromValue(it) }
                MAILFROMATTRIBUTES_DESCRIPTOR.index -> builder.mailFromAttributes = deserializeMailFromAttributesDocument(deserializer)
                POLICIES_DESCRIPTOR.index -> builder.policies =
                    deserializer.deserializeMap(POLICIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VERIFICATIONINFO_DESCRIPTOR.index -> builder.verificationInfo = deserializeVerificationInfoDocument(deserializer)
                VERIFICATIONSTATUS_DESCRIPTOR.index -> builder.verificationStatus = deserializeString().let { VerificationStatus.fromValue(it) }
                VERIFIEDFORSENDINGSTATUS_DESCRIPTOR.index -> builder.verifiedForSendingStatus = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
