// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.serde

import aws.sdk.kotlin.services.sesv2.model.GetCustomVerificationEmailTemplateResponse
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCustomVerificationEmailTemplateOperationDeserializer: HttpDeserialize<GetCustomVerificationEmailTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetCustomVerificationEmailTemplateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCustomVerificationEmailTemplateError(context, call)
        }
        val builder = GetCustomVerificationEmailTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCustomVerificationEmailTemplateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetCustomVerificationEmailTemplateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCustomVerificationEmailTemplateOperationBody(builder: GetCustomVerificationEmailTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILUREREDIRECTIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureRedirectionURL"))
    val FROMEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FromEmailAddress"))
    val SUCCESSREDIRECTIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SuccessRedirectionURL"))
    val TEMPLATECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateContent"))
    val TEMPLATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateName"))
    val TEMPLATESUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateSubject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILUREREDIRECTIONURL_DESCRIPTOR)
        field(FROMEMAILADDRESS_DESCRIPTOR)
        field(SUCCESSREDIRECTIONURL_DESCRIPTOR)
        field(TEMPLATECONTENT_DESCRIPTOR)
        field(TEMPLATENAME_DESCRIPTOR)
        field(TEMPLATESUBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILUREREDIRECTIONURL_DESCRIPTOR.index -> builder.failureRedirectionUrl = deserializeString()
                FROMEMAILADDRESS_DESCRIPTOR.index -> builder.fromEmailAddress = deserializeString()
                SUCCESSREDIRECTIONURL_DESCRIPTOR.index -> builder.successRedirectionUrl = deserializeString()
                TEMPLATECONTENT_DESCRIPTOR.index -> builder.templateContent = deserializeString()
                TEMPLATENAME_DESCRIPTOR.index -> builder.templateName = deserializeString()
                TEMPLATESUBJECT_DESCRIPTOR.index -> builder.templateSubject = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
