// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.serde

import aws.sdk.kotlin.services.sesv2.model.AccountDetails
import aws.sdk.kotlin.services.sesv2.model.GetAccountResponse
import aws.sdk.kotlin.services.sesv2.model.SendQuota
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.sdk.kotlin.services.sesv2.model.SuppressionAttributes
import aws.sdk.kotlin.services.sesv2.model.VdmAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAccountOperationDeserializer: HttpDeserialize<GetAccountResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetAccountResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAccountError(context, call)
        }
        val builder = GetAccountResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAccountOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetAccountError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccountOperationBody(builder: GetAccountResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEDICATEDIPAUTOWARMUPENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DedicatedIpAutoWarmupEnabled"))
    val DETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Details"))
    val ENFORCEMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EnforcementStatus"))
    val PRODUCTIONACCESSENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ProductionAccessEnabled"))
    val SENDQUOTA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SendQuota"))
    val SENDINGENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SendingEnabled"))
    val SUPPRESSIONATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SuppressionAttributes"))
    val VDMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VdmAttributes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEDICATEDIPAUTOWARMUPENABLED_DESCRIPTOR)
        field(DETAILS_DESCRIPTOR)
        field(ENFORCEMENTSTATUS_DESCRIPTOR)
        field(PRODUCTIONACCESSENABLED_DESCRIPTOR)
        field(SENDQUOTA_DESCRIPTOR)
        field(SENDINGENABLED_DESCRIPTOR)
        field(SUPPRESSIONATTRIBUTES_DESCRIPTOR)
        field(VDMATTRIBUTES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEDICATEDIPAUTOWARMUPENABLED_DESCRIPTOR.index -> builder.dedicatedIpAutoWarmupEnabled = deserializeBoolean()
                DETAILS_DESCRIPTOR.index -> builder.details = deserializeAccountDetailsDocument(deserializer)
                ENFORCEMENTSTATUS_DESCRIPTOR.index -> builder.enforcementStatus = deserializeString()
                PRODUCTIONACCESSENABLED_DESCRIPTOR.index -> builder.productionAccessEnabled = deserializeBoolean()
                SENDQUOTA_DESCRIPTOR.index -> builder.sendQuota = deserializeSendQuotaDocument(deserializer)
                SENDINGENABLED_DESCRIPTOR.index -> builder.sendingEnabled = deserializeBoolean()
                SUPPRESSIONATTRIBUTES_DESCRIPTOR.index -> builder.suppressionAttributes = deserializeSuppressionAttributesDocument(deserializer)
                VDMATTRIBUTES_DESCRIPTOR.index -> builder.vdmAttributes = deserializeVdmAttributesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
