// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.serde

import aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityResponse
import aws.sdk.kotlin.services.sesv2.model.DkimAttributes
import aws.sdk.kotlin.services.sesv2.model.IdentityType
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateEmailIdentityOperationDeserializer: HttpDeserialize<CreateEmailIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateEmailIdentityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateEmailIdentityError(context, call)
        }
        val builder = CreateEmailIdentityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateEmailIdentityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateEmailIdentityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateEmailIdentityOperationBody(builder: CreateEmailIdentityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DKIMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DkimAttributes"))
    val IDENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IdentityType"))
    val VERIFIEDFORSENDINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("VerifiedForSendingStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DKIMATTRIBUTES_DESCRIPTOR)
        field(IDENTITYTYPE_DESCRIPTOR)
        field(VERIFIEDFORSENDINGSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DKIMATTRIBUTES_DESCRIPTOR.index -> builder.dkimAttributes = deserializeDkimAttributesDocument(deserializer)
                IDENTITYTYPE_DESCRIPTOR.index -> builder.identityType = deserializeString().let { IdentityType.fromValue(it) }
                VERIFIEDFORSENDINGSTATUS_DESCRIPTOR.index -> builder.verifiedForSendingStatus = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
