// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains additional information about the verification status for the identity.
 */
public class VerificationInfo private constructor(builder: Builder) {
    /**
     * Provides the reason for the failure describing why Amazon SES was not able to successfully verify the identity. Below are the possible values:
     * + `INVALID_VALUE` – Amazon SES was able to find the record, but the value contained within the record was invalid. Ensure you have published the correct values for the record.
     * + `TYPE_NOT_FOUND` – The queried hostname exists but does not have the requested type of DNS record. Ensure that you have published the correct type of DNS record.
     * + `HOST_NOT_FOUND` – The queried hostname does not exist or was not reachable at the time of the request. Ensure that you have published the required DNS record(s).
     * + `SERVICE_ERROR` – A temporary issue is preventing Amazon SES from determining the verification status of the domain.
     * + `DNS_SERVER_ERROR` – The DNS server encountered an issue and was unable to complete the request.
     */
    public val errorType: aws.sdk.kotlin.services.sesv2.model.VerificationError? = builder.errorType
    /**
     * The last time a verification attempt was made for this identity.
     */
    public val lastCheckedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastCheckedTimestamp
    /**
     * The last time a successful verification was made for this identity.
     */
    public val lastSuccessTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessTimestamp
    /**
     * An object that contains information about the start of authority (SOA) record associated with the identity.
     */
    public val soaRecord: aws.sdk.kotlin.services.sesv2.model.SoaRecord? = builder.soaRecord

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.VerificationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerificationInfo(")
        append("errorType=$errorType,")
        append("lastCheckedTimestamp=$lastCheckedTimestamp,")
        append("lastSuccessTimestamp=$lastSuccessTimestamp,")
        append("soaRecord=$soaRecord")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorType?.hashCode() ?: 0
        result = 31 * result + (lastCheckedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessTimestamp?.hashCode() ?: 0)
        result = 31 * result + (soaRecord?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerificationInfo

        if (errorType != other.errorType) return false
        if (lastCheckedTimestamp != other.lastCheckedTimestamp) return false
        if (lastSuccessTimestamp != other.lastSuccessTimestamp) return false
        if (soaRecord != other.soaRecord) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.VerificationInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides the reason for the failure describing why Amazon SES was not able to successfully verify the identity. Below are the possible values:
         * + `INVALID_VALUE` – Amazon SES was able to find the record, but the value contained within the record was invalid. Ensure you have published the correct values for the record.
         * + `TYPE_NOT_FOUND` – The queried hostname exists but does not have the requested type of DNS record. Ensure that you have published the correct type of DNS record.
         * + `HOST_NOT_FOUND` – The queried hostname does not exist or was not reachable at the time of the request. Ensure that you have published the required DNS record(s).
         * + `SERVICE_ERROR` – A temporary issue is preventing Amazon SES from determining the verification status of the domain.
         * + `DNS_SERVER_ERROR` – The DNS server encountered an issue and was unable to complete the request.
         */
        public var errorType: aws.sdk.kotlin.services.sesv2.model.VerificationError? = null
        /**
         * The last time a verification attempt was made for this identity.
         */
        public var lastCheckedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time a successful verification was made for this identity.
         */
        public var lastSuccessTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that contains information about the start of authority (SOA) record associated with the identity.
         */
        public var soaRecord: aws.sdk.kotlin.services.sesv2.model.SoaRecord? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.VerificationInfo) : this() {
            this.errorType = x.errorType
            this.lastCheckedTimestamp = x.lastCheckedTimestamp
            this.lastSuccessTimestamp = x.lastSuccessTimestamp
            this.soaRecord = x.soaRecord
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.VerificationInfo = VerificationInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.SoaRecord] inside the given [block]
         */
        public fun soaRecord(block: aws.sdk.kotlin.services.sesv2.model.SoaRecord.Builder.() -> kotlin.Unit) {
            this.soaRecord = aws.sdk.kotlin.services.sesv2.model.SoaRecord.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
