// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary that describes the suppressed email address.
 */
public class SuppressedDestinationSummary private constructor(builder: Builder) {
    /**
     * The email address that's on the suppression list for your account.
     */
    public val emailAddress: kotlin.String = requireNotNull(builder.emailAddress) { "A non-null value must be provided for emailAddress" }
    /**
     * The date and time when the suppressed destination was last updated, shown in Unix time format.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateTime) { "A non-null value must be provided for lastUpdateTime" }
    /**
     * The reason that the address was added to the suppression list for your account.
     */
    public val reason: aws.sdk.kotlin.services.sesv2.model.SuppressionListReason = requireNotNull(builder.reason) { "A non-null value must be provided for reason" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.SuppressedDestinationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SuppressedDestinationSummary(")
        append("emailAddress=$emailAddress,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("reason=$reason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = emailAddress.hashCode()
        result = 31 * result + (lastUpdateTime.hashCode())
        result = 31 * result + (reason.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SuppressedDestinationSummary

        if (emailAddress != other.emailAddress) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (reason != other.reason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.SuppressedDestinationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The email address that's on the suppression list for your account.
         */
        public var emailAddress: kotlin.String? = null
        /**
         * The date and time when the suppressed destination was last updated, shown in Unix time format.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason that the address was added to the suppression list for your account.
         */
        public var reason: aws.sdk.kotlin.services.sesv2.model.SuppressionListReason? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.SuppressedDestinationSummary) : this() {
            this.emailAddress = x.emailAddress
            this.lastUpdateTime = x.lastUpdateTime
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.SuppressedDestinationSummary = SuppressedDestinationSummary(this)

        internal fun correctErrors(): Builder {
            if (emailAddress == null) emailAddress = ""
            if (lastUpdateTime == null) lastUpdateTime = Instant.fromEpochSeconds(0)
            if (reason == null) reason = SuppressionListReason.SdkUnknown("no value provided")
            return this
        }
    }
}
