// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Represents a request to send email messages to multiple destinations using Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
 */
public class SendBulkEmailRequest private constructor(builder: Builder) {
    /**
     * The list of bulk email entry objects.
     */
    public val bulkEmailEntries: List<BulkEmailEntry>? = builder.bulkEmailEntries
    /**
     * The name of the configuration set to use when sending the email.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * An object that contains the body of the message. You can specify a template message.
     */
    public val defaultContent: aws.sdk.kotlin.services.sesv2.model.BulkEmailContent? = builder.defaultContent
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using the `SendEmail` operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
     */
    public val defaultEmailTags: List<MessageTag>? = builder.defaultEmailTags
    /**
     * The address that you want bounce and complaint notifications to be sent to.
     */
    public val feedbackForwardingEmailAddress: kotlin.String? = builder.feedbackForwardingEmailAddress
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `FeedbackForwardingEmailAddress` parameter.
     *
     * For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the `FeedbackForwardingEmailAddressIdentityArn` to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the `FeedbackForwardingEmailAddress` to be feedback@example.com.
     *
     * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
     */
    public val feedbackForwardingEmailAddressIdentityArn: kotlin.String? = builder.feedbackForwardingEmailAddressIdentityArn
    /**
     * The email address to use as the "From" address for the email. The address that you specify has to be verified.
     */
    public val fromEmailAddress: kotlin.String? = builder.fromEmailAddress
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `FromEmailAddress` parameter.
     *
     * For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the `FromEmailAddressIdentityArn` to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the `FromEmailAddress` to be sender@example.com.
     *
     * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
     */
    public val fromEmailAddressIdentityArn: kotlin.String? = builder.fromEmailAddressIdentityArn
    /**
     * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.
     */
    public val replyToAddresses: List<String>? = builder.replyToAddresses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.SendBulkEmailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendBulkEmailRequest(")
        append("bulkEmailEntries=$bulkEmailEntries,")
        append("configurationSetName=$configurationSetName,")
        append("defaultContent=$defaultContent,")
        append("defaultEmailTags=$defaultEmailTags,")
        append("feedbackForwardingEmailAddress=$feedbackForwardingEmailAddress,")
        append("feedbackForwardingEmailAddressIdentityArn=$feedbackForwardingEmailAddressIdentityArn,")
        append("fromEmailAddress=$fromEmailAddress,")
        append("fromEmailAddressIdentityArn=$fromEmailAddressIdentityArn,")
        append("replyToAddresses=$replyToAddresses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bulkEmailEntries?.hashCode() ?: 0
        result = 31 * result + (configurationSetName?.hashCode() ?: 0)
        result = 31 * result + (defaultContent?.hashCode() ?: 0)
        result = 31 * result + (defaultEmailTags?.hashCode() ?: 0)
        result = 31 * result + (feedbackForwardingEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (feedbackForwardingEmailAddressIdentityArn?.hashCode() ?: 0)
        result = 31 * result + (fromEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (fromEmailAddressIdentityArn?.hashCode() ?: 0)
        result = 31 * result + (replyToAddresses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendBulkEmailRequest

        if (bulkEmailEntries != other.bulkEmailEntries) return false
        if (configurationSetName != other.configurationSetName) return false
        if (defaultContent != other.defaultContent) return false
        if (defaultEmailTags != other.defaultEmailTags) return false
        if (feedbackForwardingEmailAddress != other.feedbackForwardingEmailAddress) return false
        if (feedbackForwardingEmailAddressIdentityArn != other.feedbackForwardingEmailAddressIdentityArn) return false
        if (fromEmailAddress != other.fromEmailAddress) return false
        if (fromEmailAddressIdentityArn != other.fromEmailAddressIdentityArn) return false
        if (replyToAddresses != other.replyToAddresses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.SendBulkEmailRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of bulk email entry objects.
         */
        public var bulkEmailEntries: List<BulkEmailEntry>? = null
        /**
         * The name of the configuration set to use when sending the email.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * An object that contains the body of the message. You can specify a template message.
         */
        public var defaultContent: aws.sdk.kotlin.services.sesv2.model.BulkEmailContent? = null
        /**
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the `SendEmail` operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
         */
        public var defaultEmailTags: List<MessageTag>? = null
        /**
         * The address that you want bounce and complaint notifications to be sent to.
         */
        public var feedbackForwardingEmailAddress: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `FeedbackForwardingEmailAddress` parameter.
         *
         * For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the `FeedbackForwardingEmailAddressIdentityArn` to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the `FeedbackForwardingEmailAddress` to be feedback@example.com.
         *
         * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
         */
        public var feedbackForwardingEmailAddressIdentityArn: kotlin.String? = null
        /**
         * The email address to use as the "From" address for the email. The address that you specify has to be verified.
         */
        public var fromEmailAddress: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `FromEmailAddress` parameter.
         *
         * For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the `FromEmailAddressIdentityArn` to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the `FromEmailAddress` to be sender@example.com.
         *
         * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
         */
        public var fromEmailAddressIdentityArn: kotlin.String? = null
        /**
         * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.
         */
        public var replyToAddresses: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.SendBulkEmailRequest) : this() {
            this.bulkEmailEntries = x.bulkEmailEntries
            this.configurationSetName = x.configurationSetName
            this.defaultContent = x.defaultContent
            this.defaultEmailTags = x.defaultEmailTags
            this.feedbackForwardingEmailAddress = x.feedbackForwardingEmailAddress
            this.feedbackForwardingEmailAddressIdentityArn = x.feedbackForwardingEmailAddressIdentityArn
            this.fromEmailAddress = x.fromEmailAddress
            this.fromEmailAddressIdentityArn = x.fromEmailAddressIdentityArn
            this.replyToAddresses = x.replyToAddresses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.SendBulkEmailRequest = SendBulkEmailRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.BulkEmailContent] inside the given [block]
         */
        public fun defaultContent(block: aws.sdk.kotlin.services.sesv2.model.BulkEmailContent.Builder.() -> kotlin.Unit) {
            this.defaultContent = aws.sdk.kotlin.services.sesv2.model.BulkEmailContent.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
