// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A recommendation generated for your account.
 */
public class Recommendation private constructor(builder: Builder) {
    /**
     * The first time this issue was encountered and the recommendation was generated.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The recommendation description / disambiguator - e.g. `DKIM1` and `DKIM2` are different recommendations about your DKIM setup.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The recommendation impact, with values like `HIGH` or `LOW`.
     */
    public val impact: aws.sdk.kotlin.services.sesv2.model.RecommendationImpact? = builder.impact
    /**
     * The last time the recommendation was updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The resource affected by the recommendation, with values like `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The recommendation status, with values like `OPEN` or `FIXED`.
     */
    public val status: aws.sdk.kotlin.services.sesv2.model.RecommendationStatus? = builder.status
    /**
     * The recommendation type, with values like `DKIM`, `SPF`, `DMARC` or `BIMI`.
     */
    public val type: aws.sdk.kotlin.services.sesv2.model.RecommendationType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.Recommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Recommendation(")
        append("createdTimestamp=$createdTimestamp,")
        append("description=$description,")
        append("impact=$impact,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("resourceArn=$resourceArn,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (impact?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Recommendation

        if (createdTimestamp != other.createdTimestamp) return false
        if (description != other.description) return false
        if (impact != other.impact) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (resourceArn != other.resourceArn) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.Recommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The first time this issue was encountered and the recommendation was generated.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The recommendation description / disambiguator - e.g. `DKIM1` and `DKIM2` are different recommendations about your DKIM setup.
         */
        public var description: kotlin.String? = null
        /**
         * The recommendation impact, with values like `HIGH` or `LOW`.
         */
        public var impact: aws.sdk.kotlin.services.sesv2.model.RecommendationImpact? = null
        /**
         * The last time the recommendation was updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resource affected by the recommendation, with values like `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The recommendation status, with values like `OPEN` or `FIXED`.
         */
        public var status: aws.sdk.kotlin.services.sesv2.model.RecommendationStatus? = null
        /**
         * The recommendation type, with values like `DKIM`, `SPF`, `DMARC` or `BIMI`.
         */
        public var type: aws.sdk.kotlin.services.sesv2.model.RecommendationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.Recommendation) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.description = x.description
            this.impact = x.impact
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.resourceArn = x.resourceArn
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.Recommendation = Recommendation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
