// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Represents the raw content of an email message.
 */
public class RawMessage private constructor(builder: Builder) {
    /**
     * The raw email message. The message has to meet the following criteria:
     * + The message has to contain a header and a body, separated by one blank line.
     * + All of the required header fields must be present in the message.
     * + Each part of a multipart MIME message must be formatted properly.
     * + Attachments must be in a file format that the Amazon SES supports.
     * + The raw data of the message needs to base64-encoded if you are accessing Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an Amazon Web Services SDK, the SDK takes care of the base 64-encoding for you.
     * + If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients' email clients render the message properly.
     * + The length of any single line of text in the message can't exceed 1,000 characters. This restriction is defined in [RFC 5321](https://tools.ietf.org/html/rfc5321).
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.RawMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RawMessage(")
        append("data=$data")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = data.contentHashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RawMessage

        if (data != null) {
            if (other.data == null) return false
            if (!data.contentEquals(other.data)) return false
        } else if (other.data != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.RawMessage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The raw email message. The message has to meet the following criteria:
         * + The message has to contain a header and a body, separated by one blank line.
         * + All of the required header fields must be present in the message.
         * + Each part of a multipart MIME message must be formatted properly.
         * + Attachments must be in a file format that the Amazon SES supports.
         * + The raw data of the message needs to base64-encoded if you are accessing Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an Amazon Web Services SDK, the SDK takes care of the base 64-encoding for you.
         * + If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients' email clients render the message properly.
         * + The length of any single line of text in the message can't exceed 1,000 characters. This restriction is defined in [RFC 5321](https://tools.ietf.org/html/rfc5321).
         */
        public var data: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.RawMessage) : this() {
            this.data = x.data
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.RawMessage = RawMessage(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = ByteArray(0)
            return this
        }
    }
}
