// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * If the action is successful, the service sends back an HTTP 200 response.
 *
 * The following data is returned in JSON format by the service.
 */
public class PutEmailIdentityDkimSigningAttributesResponse private constructor(builder: Builder) {
    /**
     * The DKIM authentication status of the identity. Amazon SES determines the authentication status by searching for specific records in the DNS configuration for your domain. If you used [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) to set up DKIM authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain.
     *
     * If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses the selector that you specified. The value of the TXT record must be a public key that's paired with the private key that you specified in the process of creating the identity.
     *
     * The status can be one of the following:
     * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM records in the DNS configuration for the domain.
     * + `SUCCESS` – The verification process completed successfully.
     * + `FAILED` – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.
     * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.
     * + `NOT_STARTED` – The DKIM verification process hasn't been initiated for the domain.
     */
    public val dkimStatus: aws.sdk.kotlin.services.sesv2.model.DkimStatus? = builder.dkimStatus
    /**
     * If you used [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.
     *
     * If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector that's associated with your public key.
     *
     * Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the DNS configuration of the domain for up to 72 hours.
     */
    public val dkimTokens: List<String>? = builder.dkimTokens

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutEmailIdentityDkimSigningAttributesResponse(")
        append("dkimStatus=$dkimStatus,")
        append("dkimTokens=$dkimTokens")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dkimStatus?.hashCode() ?: 0
        result = 31 * result + (dkimTokens?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutEmailIdentityDkimSigningAttributesResponse

        if (dkimStatus != other.dkimStatus) return false
        if (dkimTokens != other.dkimTokens) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DKIM authentication status of the identity. Amazon SES determines the authentication status by searching for specific records in the DNS configuration for your domain. If you used [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) to set up DKIM authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain.
         *
         * If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses the selector that you specified. The value of the TXT record must be a public key that's paired with the private key that you specified in the process of creating the identity.
         *
         * The status can be one of the following:
         * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM records in the DNS configuration for the domain.
         * + `SUCCESS` – The verification process completed successfully.
         * + `FAILED` – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.
         * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.
         * + `NOT_STARTED` – The DKIM verification process hasn't been initiated for the domain.
         */
        public var dkimStatus: aws.sdk.kotlin.services.sesv2.model.DkimStatus? = null
        /**
         * If you used [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.
         *
         * If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector that's associated with your public key.
         *
         * Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the DNS configuration of the domain for up to 72 hours.
         */
        public var dkimTokens: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse) : this() {
            this.dkimStatus = x.dkimStatus
            this.dkimTokens = x.dkimTokens
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse = PutEmailIdentityDkimSigningAttributesResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
