// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * A request to change the DKIM attributes for an email identity.
 */
public class PutEmailIdentityDkimSigningAttributesRequest private constructor(builder: Builder) {
    /**
     * The email identity.
     */
    public val emailIdentity: kotlin.String? = builder.emailIdentity
    /**
     * An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
     */
    public val signingAttributes: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes? = builder.signingAttributes
    /**
     * The method to use to configure DKIM for the identity. There are the following possible values:
     * + `AWS_SES` – Configure DKIM for the identity by using [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
     * + `EXTERNAL` – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
     */
    public val signingAttributesOrigin: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributesOrigin? = builder.signingAttributesOrigin

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutEmailIdentityDkimSigningAttributesRequest(")
        append("emailIdentity=$emailIdentity,")
        append("signingAttributes=$signingAttributes,")
        append("signingAttributesOrigin=$signingAttributesOrigin")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = emailIdentity?.hashCode() ?: 0
        result = 31 * result + (signingAttributes?.hashCode() ?: 0)
        result = 31 * result + (signingAttributesOrigin?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutEmailIdentityDkimSigningAttributesRequest

        if (emailIdentity != other.emailIdentity) return false
        if (signingAttributes != other.signingAttributes) return false
        if (signingAttributesOrigin != other.signingAttributesOrigin) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The email identity.
         */
        public var emailIdentity: kotlin.String? = null
        /**
         * An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
         */
        public var signingAttributes: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes? = null
        /**
         * The method to use to configure DKIM for the identity. There are the following possible values:
         * + `AWS_SES` – Configure DKIM for the identity by using [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
         * + `EXTERNAL` – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
         */
        public var signingAttributesOrigin: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributesOrigin? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest) : this() {
            this.emailIdentity = x.emailIdentity
            this.signingAttributes = x.signingAttributes
            this.signingAttributesOrigin = x.signingAttributesOrigin
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest = PutEmailIdentityDkimSigningAttributesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes] inside the given [block]
         */
        public fun signingAttributes(block: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes.Builder.() -> kotlin.Unit) {
            this.signingAttributes = aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
