// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains details about the data source for the metrics export.
 */
public class MetricsDataSource private constructor(builder: Builder) {
    /**
     * An object that contains a mapping between a `MetricDimensionName` and `MetricDimensionValue` to filter metrics by. Must contain a least 1 dimension but no more than 3 unique ones.
     */
    public val dimensions: Map<MetricDimensionName, List<String>> = requireNotNull(builder.dimensions) { "A non-null value must be provided for dimensions" }
    /**
     * Represents the end date for the export interval as a timestamp.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endDate) { "A non-null value must be provided for endDate" }
    /**
     * A list of `ExportMetric` objects to export.
     */
    public val metrics: List<ExportMetric> = requireNotNull(builder.metrics) { "A non-null value must be provided for metrics" }
    /**
     * The metrics namespace - e.g., `VDM`.
     */
    public val namespace: aws.sdk.kotlin.services.sesv2.model.MetricNamespace = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }
    /**
     * Represents the start date for the export interval as a timestamp.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startDate) { "A non-null value must be provided for startDate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.MetricsDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricsDataSource(")
        append("dimensions=$dimensions,")
        append("endDate=$endDate,")
        append("metrics=$metrics,")
        append("namespace=$namespace,")
        append("startDate=$startDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions.hashCode()
        result = 31 * result + (endDate.hashCode())
        result = 31 * result + (metrics.hashCode())
        result = 31 * result + (namespace.hashCode())
        result = 31 * result + (startDate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricsDataSource

        if (dimensions != other.dimensions) return false
        if (endDate != other.endDate) return false
        if (metrics != other.metrics) return false
        if (namespace != other.namespace) return false
        if (startDate != other.startDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.MetricsDataSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains a mapping between a `MetricDimensionName` and `MetricDimensionValue` to filter metrics by. Must contain a least 1 dimension but no more than 3 unique ones.
         */
        public var dimensions: Map<MetricDimensionName, List<String>>? = null
        /**
         * Represents the end date for the export interval as a timestamp.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of `ExportMetric` objects to export.
         */
        public var metrics: List<ExportMetric>? = null
        /**
         * The metrics namespace - e.g., `VDM`.
         */
        public var namespace: aws.sdk.kotlin.services.sesv2.model.MetricNamespace? = null
        /**
         * Represents the start date for the export interval as a timestamp.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.MetricsDataSource) : this() {
            this.dimensions = x.dimensions
            this.endDate = x.endDate
            this.metrics = x.metrics
            this.namespace = x.namespace
            this.startDate = x.startDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.MetricsDataSource = MetricsDataSource(this)

        internal fun correctErrors(): Builder {
            if (dimensions == null) dimensions = emptyMap()
            if (endDate == null) endDate = Instant.fromEpochSeconds(0)
            if (metrics == null) metrics = emptyList()
            if (namespace == null) namespace = MetricNamespace.SdkUnknown("no value provided")
            if (startDate == null) startDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
