// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import kotlin.collections.List

/**
 * The metric to export, can be one of the following:
 * + `SEND` - Emails sent eligible for tracking in the VDM dashboard. This excludes emails sent to the mailbox simulator and emails addressed to more than one recipient.
 * + `COMPLAINT` - Complaints received for your account. This excludes complaints from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient
 * + `PERMANENT_BOUNCE` - Permanent bounces - i.e., feedback received for emails sent to non-existent mailboxes. Excludes bounces from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient.
 * + `TRANSIENT_BOUNCE` - Transient bounces - i.e., feedback received for delivery failures excluding issues with non-existent mailboxes. Excludes bounces from the mailbox simulator, and those for emails addressed to more than one recipient.
 * + `OPEN` - Unique open events for emails including open trackers. Excludes opens for emails addressed to more than one recipient.
 * + `CLICK` - Unique click events for emails including wrapped links. Excludes clicks for emails addressed to more than one recipient.
 * + `DELIVERY` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator and for emails addressed to more than one recipient.
 * + `DELIVERY_OPEN` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without open trackers.
 * + `DELIVERY_CLICK` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without click trackers.
 * + `DELIVERY_COMPLAINT` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails addressed to recipients hosted by ISPs with which Amazon SES does not have a feedback loop agreement.
 */
public sealed class Metric {
    public abstract val value: kotlin.String

    public object Click : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "CLICK"
        override fun toString(): kotlin.String = "Click"
    }

    public object Complaint : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "COMPLAINT"
        override fun toString(): kotlin.String = "Complaint"
    }

    public object Delivery : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "DELIVERY"
        override fun toString(): kotlin.String = "Delivery"
    }

    public object DeliveryClick : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "DELIVERY_CLICK"
        override fun toString(): kotlin.String = "DeliveryClick"
    }

    public object DeliveryComplaint : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "DELIVERY_COMPLAINT"
        override fun toString(): kotlin.String = "DeliveryComplaint"
    }

    public object DeliveryOpen : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "DELIVERY_OPEN"
        override fun toString(): kotlin.String = "DeliveryOpen"
    }

    public object Open : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "OPEN"
        override fun toString(): kotlin.String = "Open"
    }

    public object PermanentBounce : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "PERMANENT_BOUNCE"
        override fun toString(): kotlin.String = "PermanentBounce"
    }

    public object Send : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "SEND"
        override fun toString(): kotlin.String = "Send"
    }

    public object TransientBounce : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override val value: kotlin.String = "TRANSIENT_BOUNCE"
        override fun toString(): kotlin.String = "TransientBounce"
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.sesv2.model.Metric() {
        override fun toString(): kotlin.String = "SdkUnknown($value)"
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(value: kotlin.String): aws.sdk.kotlin.services.sesv2.model.Metric = when (value) {
            "CLICK" -> Click
            "COMPLAINT" -> Complaint
            "DELIVERY" -> Delivery
            "DELIVERY_CLICK" -> DeliveryClick
            "DELIVERY_COMPLAINT" -> DeliveryComplaint
            "DELIVERY_OPEN" -> DeliveryOpen
            "OPEN" -> Open
            "PERMANENT_BOUNCE" -> PermanentBounce
            "SEND" -> Send
            "TRANSIENT_BOUNCE" -> TransientBounce
            else -> SdkUnknown(value)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.sesv2.model.Metric> = values

        private val values: kotlin.collections.List<aws.sdk.kotlin.services.sesv2.model.Metric> = listOf(
            Click,
            Complaint,
            Delivery,
            DeliveryClick,
            DeliveryComplaint,
            DeliveryOpen,
            Open,
            PermanentBounce,
            Send,
            TransientBounce,
        )
    }
}
