// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object containing Message Insights filters.
 *
 * If you specify multiple filters, the filters are joined by AND.
 *
 * If you specify multiple values for a filter, the values are joined by OR. Filter values are case-sensitive.
 *
 * `FromEmailAddress`, `Destination`, and `Subject` filters support partial match. A partial match is performed by using the `*` wildcard character placed at the beginning (suffix match), the end (prefix match) or both ends of the string (contains match). In order to match the literal characters `*` or `\`, they must be escaped using the `\` character. If no wildcard character is present, an exact match is performed.
 */
public class MessageInsightsFilters private constructor(builder: Builder) {
    /**
     * The recipient's email address.
     */
    public val destination: List<String>? = builder.destination
    /**
     * The from address used to send the message.
     */
    public val fromEmailAddress: List<String>? = builder.fromEmailAddress
    /**
     * The recipient's ISP (e.g., `Gmail`, `Yahoo`, etc.).
     */
    public val isp: List<String>? = builder.isp
    /**
     * The last delivery-related event for the email, where the ordering is as follows: `SEND` < `BOUNCE` < `DELIVERY` < `COMPLAINT`.
     */
    public val lastDeliveryEvent: List<DeliveryEventType>? = builder.lastDeliveryEvent
    /**
     * The last engagement-related event for the email, where the ordering is as follows: `OPEN` < `CLICK`.
     *
     *  Engagement events are only available if [Engagement tracking](https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html) is enabled.
     */
    public val lastEngagementEvent: List<EngagementEventType>? = builder.lastEngagementEvent
    /**
     * The subject line of the message.
     */
    public val subject: List<String>? = builder.subject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageInsightsFilters(")
        append("destination=$destination,")
        append("fromEmailAddress=$fromEmailAddress,")
        append("isp=$isp,")
        append("lastDeliveryEvent=$lastDeliveryEvent,")
        append("lastEngagementEvent=$lastEngagementEvent,")
        append("subject=$subject")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (fromEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (isp?.hashCode() ?: 0)
        result = 31 * result + (lastDeliveryEvent?.hashCode() ?: 0)
        result = 31 * result + (lastEngagementEvent?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageInsightsFilters

        if (destination != other.destination) return false
        if (fromEmailAddress != other.fromEmailAddress) return false
        if (isp != other.isp) return false
        if (lastDeliveryEvent != other.lastDeliveryEvent) return false
        if (lastEngagementEvent != other.lastEngagementEvent) return false
        if (subject != other.subject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The recipient's email address.
         */
        public var destination: List<String>? = null
        /**
         * The from address used to send the message.
         */
        public var fromEmailAddress: List<String>? = null
        /**
         * The recipient's ISP (e.g., `Gmail`, `Yahoo`, etc.).
         */
        public var isp: List<String>? = null
        /**
         * The last delivery-related event for the email, where the ordering is as follows: `SEND` < `BOUNCE` < `DELIVERY` < `COMPLAINT`.
         */
        public var lastDeliveryEvent: List<DeliveryEventType>? = null
        /**
         * The last engagement-related event for the email, where the ordering is as follows: `OPEN` < `CLICK`.
         *
         *  Engagement events are only available if [Engagement tracking](https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html) is enabled.
         */
        public var lastEngagementEvent: List<EngagementEventType>? = null
        /**
         * The subject line of the message.
         */
        public var subject: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters) : this() {
            this.destination = x.destination
            this.fromEmailAddress = x.fromEmailAddress
            this.isp = x.isp
            this.lastDeliveryEvent = x.lastDeliveryEvent
            this.lastEngagementEvent = x.lastEngagementEvent
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters = MessageInsightsFilters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
