// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains filters applied when performing the Message Insights export.
 */
public class MessageInsightsDataSource private constructor(builder: Builder) {
    /**
     * Represents the end date for the export interval as a timestamp. The end date is inclusive.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endDate) { "A non-null value must be provided for endDate" }
    /**
     * Filters for results to be excluded from the export file.
     */
    public val exclude: aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters? = builder.exclude
    /**
     * Filters for results to be included in the export file.
     */
    public val include: aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters? = builder.include
    /**
     * The maximum number of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Represents the start date for the export interval as a timestamp. The start date is inclusive.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startDate) { "A non-null value must be provided for startDate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.MessageInsightsDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageInsightsDataSource(")
        append("endDate=$endDate,")
        append("exclude=$exclude,")
        append("include=$include,")
        append("maxResults=$maxResults,")
        append("startDate=$startDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate.hashCode()
        result = 31 * result + (exclude?.hashCode() ?: 0)
        result = 31 * result + (include?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (startDate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageInsightsDataSource

        if (endDate != other.endDate) return false
        if (exclude != other.exclude) return false
        if (include != other.include) return false
        if (maxResults != other.maxResults) return false
        if (startDate != other.startDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.MessageInsightsDataSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Represents the end date for the export interval as a timestamp. The end date is inclusive.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Filters for results to be excluded from the export file.
         */
        public var exclude: aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters? = null
        /**
         * Filters for results to be included in the export file.
         */
        public var include: aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters? = null
        /**
         * The maximum number of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Represents the start date for the export interval as a timestamp. The start date is inclusive.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.MessageInsightsDataSource) : this() {
            this.endDate = x.endDate
            this.exclude = x.exclude
            this.include = x.include
            this.maxResults = x.maxResults
            this.startDate = x.startDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.MessageInsightsDataSource = MessageInsightsDataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters] inside the given [block]
         */
        public fun exclude(block: aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters.Builder.() -> kotlin.Unit) {
            this.exclude = aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters] inside the given [block]
         */
        public fun include(block: aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters.Builder.() -> kotlin.Unit) {
            this.include = aws.sdk.kotlin.services.sesv2.model.MessageInsightsFilters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (endDate == null) endDate = Instant.fromEpochSeconds(0)
            if (startDate == null) startDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
