// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Represents a request to list all of the import jobs for a data destination within the specified maximum number of import jobs.
 */
public class ListImportJobsRequest private constructor(builder: Builder) {
    /**
     * The destination of the import job, which can be used to list import jobs that have a certain `ImportDestinationType`.
     */
    public val importDestinationType: aws.sdk.kotlin.services.sesv2.model.ImportDestinationType? = builder.importDestinationType
    /**
     * A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to `ListImportJobs` with the same parameters to retrieve the next page of import jobs.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the `NextToken` element is sent in the response. Use the `NextToken` value in subsequent requests to retrieve additional addresses.
     */
    public val pageSize: kotlin.Int? = builder.pageSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.ListImportJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListImportJobsRequest(")
        append("importDestinationType=$importDestinationType,")
        append("nextToken=$nextToken,")
        append("pageSize=$pageSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = importDestinationType?.hashCode() ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (pageSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListImportJobsRequest

        if (importDestinationType != other.importDestinationType) return false
        if (nextToken != other.nextToken) return false
        if (pageSize != other.pageSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.ListImportJobsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination of the import job, which can be used to list import jobs that have a certain `ImportDestinationType`.
         */
        public var importDestinationType: aws.sdk.kotlin.services.sesv2.model.ImportDestinationType? = null
        /**
         * A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to `ListImportJobs` with the same parameters to retrieve the next page of import jobs.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the `NextToken` element is sent in the response. Use the `NextToken` value in subsequent requests to retrieve additional addresses.
         */
        public var pageSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.ListImportJobsRequest) : this() {
            this.importDestinationType = x.importDestinationType
            this.nextToken = x.nextToken
            this.pageSize = x.pageSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.ListImportJobsRequest = ListImportJobsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
