// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object containing details about a specific event.
 */
public class InsightsEvent private constructor(builder: Builder) {
    /**
     * Details about bounce or complaint events.
     */
    public val details: aws.sdk.kotlin.services.sesv2.model.EventDetails? = builder.details
    /**
     * The timestamp of the event.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The type of event:
     * + `SEND` - The send request was successful and SES will attempt to deliver the message to the recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a send, but delivery is suppressed.)
     * + `DELIVERY` - SES successfully delivered the email to the recipient's mail server. Excludes deliveries to the mailbox simulator, and those from emails addressed to more than one recipient.
     * + `BOUNCE` - Feedback received for delivery failures. Additional details about the bounce are provided in the `Details` object. Excludes bounces from the mailbox simulator, and those from emails addressed to more than one recipient.
     * + `COMPLAINT` - Complaint received for the email. Additional details about the complaint are provided in the `Details` object. This excludes complaints from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those from emails addressed to more than one recipient.
     * + `OPEN` - Open event for emails including open trackers. Excludes opens for emails addressed to more than one recipient.
     * + `CLICK` - Click event for emails including wrapped links. Excludes clicks for emails addressed to more than one recipient.
     */
    public val type: aws.sdk.kotlin.services.sesv2.model.EventType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.InsightsEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightsEvent(")
        append("details=$details,")
        append("timestamp=$timestamp,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightsEvent

        if (details != other.details) return false
        if (timestamp != other.timestamp) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.InsightsEvent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Details about bounce or complaint events.
         */
        public var details: aws.sdk.kotlin.services.sesv2.model.EventDetails? = null
        /**
         * The timestamp of the event.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of event:
         * + `SEND` - The send request was successful and SES will attempt to deliver the message to the recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a send, but delivery is suppressed.)
         * + `DELIVERY` - SES successfully delivered the email to the recipient's mail server. Excludes deliveries to the mailbox simulator, and those from emails addressed to more than one recipient.
         * + `BOUNCE` - Feedback received for delivery failures. Additional details about the bounce are provided in the `Details` object. Excludes bounces from the mailbox simulator, and those from emails addressed to more than one recipient.
         * + `COMPLAINT` - Complaint received for the email. Additional details about the complaint are provided in the `Details` object. This excludes complaints from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those from emails addressed to more than one recipient.
         * + `OPEN` - Open event for emails including open trackers. Excludes opens for emails addressed to more than one recipient.
         * + `CLICK` - Click event for emails including wrapped links. Excludes clicks for emails addressed to more than one recipient.
         */
        public var type: aws.sdk.kotlin.services.sesv2.model.EventType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.InsightsEvent) : this() {
            this.details = x.details
            this.timestamp = x.timestamp
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.InsightsEvent = InsightsEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.EventDetails] inside the given [block]
         */
        public fun details(block: aws.sdk.kotlin.services.sesv2.model.EventDetails.Builder.() -> kotlin.Unit) {
            this.details = aws.sdk.kotlin.services.sesv2.model.EventDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
