// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that contains a mapping between a `Metric` and `MetricAggregation`.
 */
public class ExportMetric private constructor(builder: Builder) {
    /**
     * The aggregation to apply to a metric, can be one of the following:
     * + `VOLUME` - The volume of events for this metric.
     * + `RATE` - The rate for this metric relative to the `SEND` metric volume.
     */
    public val aggregation: aws.sdk.kotlin.services.sesv2.model.MetricAggregation? = builder.aggregation
    /**
     * The metric to export, can be one of the following:
     * + `SEND` - Emails sent eligible for tracking in the VDM dashboard. This excludes emails sent to the mailbox simulator and emails addressed to more than one recipient.
     * + `COMPLAINT` - Complaints received for your account. This excludes complaints from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient
     * + `PERMANENT_BOUNCE` - Permanent bounces - i.e., feedback received for emails sent to non-existent mailboxes. Excludes bounces from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient.
     * + `TRANSIENT_BOUNCE` - Transient bounces - i.e., feedback received for delivery failures excluding issues with non-existent mailboxes. Excludes bounces from the mailbox simulator, and those for emails addressed to more than one recipient.
     * + `OPEN` - Unique open events for emails including open trackers. Excludes opens for emails addressed to more than one recipient.
     * + `CLICK` - Unique click events for emails including wrapped links. Excludes clicks for emails addressed to more than one recipient.
     * + `DELIVERY` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator and for emails addressed to more than one recipient.
     * + `DELIVERY_OPEN` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without open trackers.
     * + `DELIVERY_CLICK` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without click trackers.
     * + `DELIVERY_COMPLAINT` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails addressed to recipients hosted by ISPs with which Amazon SES does not have a feedback loop agreement.
     */
    public val name: aws.sdk.kotlin.services.sesv2.model.Metric? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.ExportMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportMetric(")
        append("aggregation=$aggregation,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregation?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportMetric

        if (aggregation != other.aggregation) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.ExportMetric = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The aggregation to apply to a metric, can be one of the following:
         * + `VOLUME` - The volume of events for this metric.
         * + `RATE` - The rate for this metric relative to the `SEND` metric volume.
         */
        public var aggregation: aws.sdk.kotlin.services.sesv2.model.MetricAggregation? = null
        /**
         * The metric to export, can be one of the following:
         * + `SEND` - Emails sent eligible for tracking in the VDM dashboard. This excludes emails sent to the mailbox simulator and emails addressed to more than one recipient.
         * + `COMPLAINT` - Complaints received for your account. This excludes complaints from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient
         * + `PERMANENT_BOUNCE` - Permanent bounces - i.e., feedback received for emails sent to non-existent mailboxes. Excludes bounces from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient.
         * + `TRANSIENT_BOUNCE` - Transient bounces - i.e., feedback received for delivery failures excluding issues with non-existent mailboxes. Excludes bounces from the mailbox simulator, and those for emails addressed to more than one recipient.
         * + `OPEN` - Unique open events for emails including open trackers. Excludes opens for emails addressed to more than one recipient.
         * + `CLICK` - Unique click events for emails including wrapped links. Excludes clicks for emails addressed to more than one recipient.
         * + `DELIVERY` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator and for emails addressed to more than one recipient.
         * + `DELIVERY_OPEN` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without open trackers.
         * + `DELIVERY_CLICK` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without click trackers.
         * + `DELIVERY_COMPLAINT` - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails addressed to recipients hosted by ISPs with which Amazon SES does not have a feedback loop agreement.
         */
        public var name: aws.sdk.kotlin.services.sesv2.model.Metric? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.ExportMetric) : this() {
            this.aggregation = x.aggregation
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.ExportMetric = ExportMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
