// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that contains details about the destination of the export job.
 */
public class ExportDestination private constructor(builder: Builder) {
    /**
     * The data format of the final export job file, can be one of the following:
     * + `CSV` - A comma-separated values file.
     * + `JSON` - A Json file.
     */
    public val dataFormat: aws.sdk.kotlin.services.sesv2.model.DataFormat = requireNotNull(builder.dataFormat) { "A non-null value must be provided for dataFormat" }
    /**
     * An Amazon S3 pre-signed URL that points to the generated export file.
     */
    public val s3Url: kotlin.String? = builder.s3Url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.ExportDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportDestination(")
        append("dataFormat=$dataFormat,")
        append("s3Url=$s3Url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataFormat.hashCode()
        result = 31 * result + (s3Url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportDestination

        if (dataFormat != other.dataFormat) return false
        if (s3Url != other.s3Url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.ExportDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data format of the final export job file, can be one of the following:
         * + `CSV` - A comma-separated values file.
         * + `JSON` - A Json file.
         */
        public var dataFormat: aws.sdk.kotlin.services.sesv2.model.DataFormat? = null
        /**
         * An Amazon S3 pre-signed URL that points to the generated export file.
         */
        public var s3Url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.ExportDestination) : this() {
            this.dataFormat = x.dataFormat
            this.s3Url = x.s3Url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.ExportDestination = ExportDestination(this)

        internal fun correctErrors(): Builder {
            if (dataFormat == null) dataFormat = DataFormat.SdkUnknown("no value provided")
            return this
        }
    }
}
