// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that contains inbox placement data for email sent from one of your email domains to a specific email provider.
 */
public class DomainIspPlacement private constructor(builder: Builder) {
    /**
     * The percentage of messages that were sent from the selected domain to the specified email provider that arrived in recipients' inboxes.
     */
    public val inboxPercentage: kotlin.Double? = builder.inboxPercentage
    /**
     * The total number of messages that were sent from the selected domain to the specified email provider that arrived in recipients' inboxes.
     */
    public val inboxRawCount: kotlin.Long? = builder.inboxRawCount
    /**
     * The name of the email provider that the inbox placement data applies to.
     */
    public val ispName: kotlin.String? = builder.ispName
    /**
     * The percentage of messages that were sent from the selected domain to the specified email provider that arrived in recipients' spam or junk mail folders.
     */
    public val spamPercentage: kotlin.Double? = builder.spamPercentage
    /**
     * The total number of messages that were sent from the selected domain to the specified email provider that arrived in recipients' spam or junk mail folders.
     */
    public val spamRawCount: kotlin.Long? = builder.spamRawCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.DomainIspPlacement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainIspPlacement(")
        append("inboxPercentage=$inboxPercentage,")
        append("inboxRawCount=$inboxRawCount,")
        append("ispName=$ispName,")
        append("spamPercentage=$spamPercentage,")
        append("spamRawCount=$spamRawCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inboxPercentage?.hashCode() ?: 0
        result = 31 * result + (inboxRawCount?.hashCode() ?: 0)
        result = 31 * result + (ispName?.hashCode() ?: 0)
        result = 31 * result + (spamPercentage?.hashCode() ?: 0)
        result = 31 * result + (spamRawCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainIspPlacement

        if (inboxPercentage != other.inboxPercentage) return false
        if (inboxRawCount != other.inboxRawCount) return false
        if (ispName != other.ispName) return false
        if (spamPercentage != other.spamPercentage) return false
        if (spamRawCount != other.spamRawCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.DomainIspPlacement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The percentage of messages that were sent from the selected domain to the specified email provider that arrived in recipients' inboxes.
         */
        public var inboxPercentage: kotlin.Double? = null
        /**
         * The total number of messages that were sent from the selected domain to the specified email provider that arrived in recipients' inboxes.
         */
        public var inboxRawCount: kotlin.Long? = null
        /**
         * The name of the email provider that the inbox placement data applies to.
         */
        public var ispName: kotlin.String? = null
        /**
         * The percentage of messages that were sent from the selected domain to the specified email provider that arrived in recipients' spam or junk mail folders.
         */
        public var spamPercentage: kotlin.Double? = null
        /**
         * The total number of messages that were sent from the selected domain to the specified email provider that arrived in recipients' spam or junk mail folders.
         */
        public var spamRawCount: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.DomainIspPlacement) : this() {
            this.inboxPercentage = x.inboxPercentage
            this.inboxRawCount = x.inboxRawCount
            this.ispName = x.ispName
            this.spamPercentage = x.spamPercentage
            this.spamRawCount = x.spamRawCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.DomainIspPlacement = DomainIspPlacement(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
