// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that contains configuration for Bring Your Own DKIM (BYODKIM), or, for Easy DKIM
 */
public class DkimSigningAttributes private constructor(builder: Builder) {
    /**
     * &#91;Bring Your Own DKIM&#93; A private key that's used to generate a DKIM signature.
     *
     * The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
     */
    public val domainSigningPrivateKey: kotlin.String? = builder.domainSigningPrivateKey
    /**
     * &#91;Bring Your Own DKIM&#93; A string that's used to identify a public key in the DNS configuration for a domain.
     */
    public val domainSigningSelector: kotlin.String? = builder.domainSigningSelector
    /**
     * &#91;Easy DKIM&#93; The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
     */
    public val nextSigningKeyLength: aws.sdk.kotlin.services.sesv2.model.DkimSigningKeyLength? = builder.nextSigningKeyLength

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DkimSigningAttributes(")
        append("domainSigningPrivateKey=*** Sensitive Data Redacted ***,")
        append("domainSigningSelector=$domainSigningSelector,")
        append("nextSigningKeyLength=$nextSigningKeyLength")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainSigningPrivateKey?.hashCode() ?: 0
        result = 31 * result + (domainSigningSelector?.hashCode() ?: 0)
        result = 31 * result + (nextSigningKeyLength?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DkimSigningAttributes

        if (domainSigningPrivateKey != other.domainSigningPrivateKey) return false
        if (domainSigningSelector != other.domainSigningSelector) return false
        if (nextSigningKeyLength != other.nextSigningKeyLength) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;Bring Your Own DKIM&#93; A private key that's used to generate a DKIM signature.
         *
         * The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
         */
        public var domainSigningPrivateKey: kotlin.String? = null
        /**
         * &#91;Bring Your Own DKIM&#93; A string that's used to identify a public key in the DNS configuration for a domain.
         */
        public var domainSigningSelector: kotlin.String? = null
        /**
         * &#91;Easy DKIM&#93; The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
         */
        public var nextSigningKeyLength: aws.sdk.kotlin.services.sesv2.model.DkimSigningKeyLength? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes) : this() {
            this.domainSigningPrivateKey = x.domainSigningPrivateKey
            this.domainSigningSelector = x.domainSigningSelector
            this.nextSigningKeyLength = x.nextSigningKeyLength
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes = DkimSigningAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
