// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that describes the recipients for an email.
 *
 * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the *local part* of a destination email address (the part of the email address that precedes the @ sign) may only contain [7-bit ASCII characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If the *domain part* of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in [RFC3492](https://tools.ietf.org/html/rfc3492.html).
 */
public class Destination private constructor(builder: Builder) {
    /**
     * An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
     */
    public val bccAddresses: List<String>? = builder.bccAddresses
    /**
     * An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
     */
    public val ccAddresses: List<String>? = builder.ccAddresses
    /**
     * An array that contains the email addresses of the "To" recipients for the email.
     */
    public val toAddresses: List<String>? = builder.toAddresses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("bccAddresses=$bccAddresses,")
        append("ccAddresses=$ccAddresses,")
        append("toAddresses=$toAddresses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bccAddresses?.hashCode() ?: 0
        result = 31 * result + (ccAddresses?.hashCode() ?: 0)
        result = 31 * result + (toAddresses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (bccAddresses != other.bccAddresses) return false
        if (ccAddresses != other.ccAddresses) return false
        if (toAddresses != other.toAddresses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.Destination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
         */
        public var bccAddresses: List<String>? = null
        /**
         * An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
         */
        public var ccAddresses: List<String>? = null
        /**
         * An array that contains the email addresses of the "To" recipients for the email.
         */
        public var toAddresses: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.Destination) : this() {
            this.bccAddresses = x.bccAddresses
            this.ccAddresses = x.ccAddresses
            this.toAddresses = x.toAddresses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.Destination = Destination(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
