// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import kotlin.collections.List

/**
 * The type of delivery events:
 * + `SEND` - The send request was successful and SES will attempt to deliver the message to the recipient’s mail server. (If account-level or global suppression is being used, SES will still count it as a send, but delivery is suppressed.)
 * + `DELIVERY` - SES successfully delivered the email to the recipient's mail server. Excludes deliveries to the mailbox simulator and emails addressed to more than one recipient.
 * + `TRANSIENT_BOUNCE` - Feedback received for delivery failures excluding issues with non-existent mailboxes. Excludes bounces from the mailbox simulator, and those from emails addressed to more than one recipient.
 * + `PERMANENT_BOUNCE` - Feedback received for emails sent to non-existent mailboxes. Excludes bounces from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those from emails addressed to more than one recipient.
 * + `UNDETERMINED_BOUNCE` - SES was unable to determine the bounce reason.
 * + `COMPLAINT` - Complaint received for the email. This excludes complaints from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those from emails addressed to more than one recipient.
 */
public sealed class DeliveryEventType {
    public abstract val value: kotlin.String

    public object Complaint : aws.sdk.kotlin.services.sesv2.model.DeliveryEventType() {
        override val value: kotlin.String = "COMPLAINT"
        override fun toString(): kotlin.String = "Complaint"
    }

    public object Delivery : aws.sdk.kotlin.services.sesv2.model.DeliveryEventType() {
        override val value: kotlin.String = "DELIVERY"
        override fun toString(): kotlin.String = "Delivery"
    }

    public object PermanentBounce : aws.sdk.kotlin.services.sesv2.model.DeliveryEventType() {
        override val value: kotlin.String = "PERMANENT_BOUNCE"
        override fun toString(): kotlin.String = "PermanentBounce"
    }

    public object Send : aws.sdk.kotlin.services.sesv2.model.DeliveryEventType() {
        override val value: kotlin.String = "SEND"
        override fun toString(): kotlin.String = "Send"
    }

    public object TransientBounce : aws.sdk.kotlin.services.sesv2.model.DeliveryEventType() {
        override val value: kotlin.String = "TRANSIENT_BOUNCE"
        override fun toString(): kotlin.String = "TransientBounce"
    }

    public object UndeterminedBounce : aws.sdk.kotlin.services.sesv2.model.DeliveryEventType() {
        override val value: kotlin.String = "UNDETERMINED_BOUNCE"
        override fun toString(): kotlin.String = "UndeterminedBounce"
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.sesv2.model.DeliveryEventType() {
        override fun toString(): kotlin.String = "SdkUnknown($value)"
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(value: kotlin.String): aws.sdk.kotlin.services.sesv2.model.DeliveryEventType = when (value) {
            "COMPLAINT" -> Complaint
            "DELIVERY" -> Delivery
            "PERMANENT_BOUNCE" -> PermanentBounce
            "SEND" -> Send
            "TRANSIENT_BOUNCE" -> TransientBounce
            "UNDETERMINED_BOUNCE" -> UndeterminedBounce
            else -> SdkUnknown(value)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.sesv2.model.DeliveryEventType> = values

        private val values: kotlin.collections.List<aws.sdk.kotlin.services.sesv2.model.DeliveryEventType> = listOf(
            Complaint,
            Delivery,
            PermanentBounce,
            Send,
            TransientBounce,
            UndeterminedBounce,
        )
    }
}
