// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Contains information about a dedicated IP pool.
 */
public class DedicatedIpPool private constructor(builder: Builder) {
    /**
     * The name of the dedicated IP pool.
     */
    public val poolName: kotlin.String = requireNotNull(builder.poolName) { "A non-null value must be provided for poolName" }
    /**
     * The type of the dedicated IP pool.
     * + `STANDARD` – A dedicated IP pool where you can control which IPs are part of the pool.
     * + `MANAGED` – A dedicated IP pool where the reputation and number of IPs are automatically managed by Amazon SES.
     */
    public val scalingMode: aws.sdk.kotlin.services.sesv2.model.ScalingMode = requireNotNull(builder.scalingMode) { "A non-null value must be provided for scalingMode" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.DedicatedIpPool = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DedicatedIpPool(")
        append("poolName=$poolName,")
        append("scalingMode=$scalingMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = poolName.hashCode()
        result = 31 * result + (scalingMode.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DedicatedIpPool

        if (poolName != other.poolName) return false
        if (scalingMode != other.scalingMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.DedicatedIpPool = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the dedicated IP pool.
         */
        public var poolName: kotlin.String? = null
        /**
         * The type of the dedicated IP pool.
         * + `STANDARD` – A dedicated IP pool where you can control which IPs are part of the pool.
         * + `MANAGED` – A dedicated IP pool where the reputation and number of IPs are automatically managed by Amazon SES.
         */
        public var scalingMode: aws.sdk.kotlin.services.sesv2.model.ScalingMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.DedicatedIpPool) : this() {
            this.poolName = x.poolName
            this.scalingMode = x.scalingMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.DedicatedIpPool = DedicatedIpPool(this)

        internal fun correctErrors(): Builder {
            if (poolName == null) poolName = ""
            if (scalingMode == null) scalingMode = ScalingMode.SdkUnknown("no value provided")
            return this
        }
    }
}
