// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Contains information about a dedicated IP address that is associated with your Amazon SES account.
 *
 * To learn more about requesting dedicated IP addresses, see [Requesting and Relinquishing Dedicated IP Addresses](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/dedicated-ip-case.html) in the *Amazon SES Developer Guide*.
 */
public class DedicatedIp private constructor(builder: Builder) {
    /**
     * An IPv4 address.
     */
    public val ip: kotlin.String = requireNotNull(builder.ip) { "A non-null value must be provided for ip" }
    /**
     * The name of the dedicated IP pool that the IP address is associated with.
     */
    public val poolName: kotlin.String? = builder.poolName
    /**
     * Indicates how complete the dedicated IP warm-up process is. When this value equals 1, the address has completed the warm-up process and is ready for use.
     */
    public val warmupPercentage: kotlin.Int = requireNotNull(builder.warmupPercentage) { "A non-null value must be provided for warmupPercentage" }
    /**
     * The warm-up status of a dedicated IP address. The status can have one of the following values:
     * + `IN_PROGRESS` – The IP address isn't ready to use because the dedicated IP warm-up process is ongoing.
     * + `DONE` – The dedicated IP warm-up process is complete, and the IP address is ready to use.
     */
    public val warmupStatus: aws.sdk.kotlin.services.sesv2.model.WarmupStatus = requireNotNull(builder.warmupStatus) { "A non-null value must be provided for warmupStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.DedicatedIp = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DedicatedIp(")
        append("ip=$ip,")
        append("poolName=$poolName,")
        append("warmupPercentage=$warmupPercentage,")
        append("warmupStatus=$warmupStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ip.hashCode()
        result = 31 * result + (poolName?.hashCode() ?: 0)
        result = 31 * result + (warmupPercentage)
        result = 31 * result + (warmupStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DedicatedIp

        if (ip != other.ip) return false
        if (poolName != other.poolName) return false
        if (warmupPercentage != other.warmupPercentage) return false
        if (warmupStatus != other.warmupStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.DedicatedIp = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An IPv4 address.
         */
        public var ip: kotlin.String? = null
        /**
         * The name of the dedicated IP pool that the IP address is associated with.
         */
        public var poolName: kotlin.String? = null
        /**
         * Indicates how complete the dedicated IP warm-up process is. When this value equals 1, the address has completed the warm-up process and is ready for use.
         */
        public var warmupPercentage: kotlin.Int? = null
        /**
         * The warm-up status of a dedicated IP address. The status can have one of the following values:
         * + `IN_PROGRESS` – The IP address isn't ready to use because the dedicated IP warm-up process is ongoing.
         * + `DONE` – The dedicated IP warm-up process is complete, and the IP address is ready to use.
         */
        public var warmupStatus: aws.sdk.kotlin.services.sesv2.model.WarmupStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.DedicatedIp) : this() {
            this.ip = x.ip
            this.poolName = x.poolName
            this.warmupPercentage = x.warmupPercentage
            this.warmupStatus = x.warmupStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.DedicatedIp = DedicatedIp(this)

        internal fun correctErrors(): Builder {
            if (ip == null) ip = ""
            if (warmupPercentage == null) warmupPercentage = 0
            if (warmupStatus == null) warmupStatus = WarmupStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
