// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * If the email identity is a domain, this object contains information about the DKIM verification status for the domain.
 *
 * If the email identity is an email address, this object is empty.
 */
public class CreateEmailIdentityResponse private constructor(builder: Builder) {
    /**
     * An object that contains information about the DKIM attributes for the identity.
     */
    public val dkimAttributes: aws.sdk.kotlin.services.sesv2.model.DkimAttributes? = builder.dkimAttributes
    /**
     * The email identity type. Note: the `MANAGED_DOMAIN` identity type is not supported.
     */
    public val identityType: aws.sdk.kotlin.services.sesv2.model.IdentityType? = builder.identityType
    /**
     * Specifies whether or not the identity is verified. You can only send email from verified email addresses or domains. For more information about verifying identities, see the [Amazon Pinpoint User Guide](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
     */
    public val verifiedForSendingStatus: kotlin.Boolean = builder.verifiedForSendingStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEmailIdentityResponse(")
        append("dkimAttributes=$dkimAttributes,")
        append("identityType=$identityType,")
        append("verifiedForSendingStatus=$verifiedForSendingStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dkimAttributes?.hashCode() ?: 0
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (verifiedForSendingStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEmailIdentityResponse

        if (dkimAttributes != other.dkimAttributes) return false
        if (identityType != other.identityType) return false
        if (verifiedForSendingStatus != other.verifiedForSendingStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains information about the DKIM attributes for the identity.
         */
        public var dkimAttributes: aws.sdk.kotlin.services.sesv2.model.DkimAttributes? = null
        /**
         * The email identity type. Note: the `MANAGED_DOMAIN` identity type is not supported.
         */
        public var identityType: aws.sdk.kotlin.services.sesv2.model.IdentityType? = null
        /**
         * Specifies whether or not the identity is verified. You can only send email from verified email addresses or domains. For more information about verifying identities, see the [Amazon Pinpoint User Guide](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
         */
        public var verifiedForSendingStatus: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityResponse) : this() {
            this.dkimAttributes = x.dkimAttributes
            this.identityType = x.identityType
            this.verifiedForSendingStatus = x.verifiedForSendingStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityResponse = CreateEmailIdentityResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.DkimAttributes] inside the given [block]
         */
        public fun dkimAttributes(block: aws.sdk.kotlin.services.sesv2.model.DkimAttributes.Builder.() -> kotlin.Unit) {
            this.dkimAttributes = aws.sdk.kotlin.services.sesv2.model.DkimAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
