// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Represents a request to create a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html).
 */
public class CreateEmailIdentityPolicyRequest private constructor(builder: Builder) {
    /**
     * The email identity.
     */
    public val emailIdentity: kotlin.String? = builder.emailIdentity
    /**
     * The text of the policy in JSON format. The policy cannot exceed 4 KB.
     *
     * For information about the syntax of sending authorization policies, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The name of the policy.
     *
     * The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
     */
    public val policyName: kotlin.String? = builder.policyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEmailIdentityPolicyRequest(")
        append("emailIdentity=$emailIdentity,")
        append("policy=$policy,")
        append("policyName=$policyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = emailIdentity?.hashCode() ?: 0
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEmailIdentityPolicyRequest

        if (emailIdentity != other.emailIdentity) return false
        if (policy != other.policy) return false
        if (policyName != other.policyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The email identity.
         */
        public var emailIdentity: kotlin.String? = null
        /**
         * The text of the policy in JSON format. The policy cannot exceed 4 KB.
         *
         * For information about the syntax of sending authorization policies, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
         */
        public var policy: kotlin.String? = null
        /**
         * The name of the policy.
         *
         * The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
         */
        public var policyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityPolicyRequest) : this() {
            this.emailIdentity = x.emailIdentity
            this.policy = x.policy
            this.policyName = x.policyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityPolicyRequest = CreateEmailIdentityPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
