// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that defines the dimension configuration to use when you send email events to Amazon CloudWatch.
 */
public class CloudWatchDimensionConfiguration private constructor(builder: Builder) {
    /**
     * The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email. This value has to meet the following criteria:
     * + Can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-), at signs (@), and periods (.).
     * + It can contain no more than 256 characters.
     */
    public val defaultDimensionValue: kotlin.String = requireNotNull(builder.defaultDimensionValue) { "A non-null value must be provided for defaultDimensionValue" }
    /**
     * The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to meet the following criteria:
     * + It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     * + It can contain no more than 256 characters.
     */
    public val dimensionName: kotlin.String = requireNotNull(builder.dimensionName) { "A non-null value must be provided for dimensionName" }
    /**
     * The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an `X-SES-MESSAGE-TAGS` header or a parameter to the `SendEmail` or `SendRawEmail` API, choose `messageTag`. To use your own email headers, choose `emailHeader`. To use link tags, choose `linkTags`.
     */
    public val dimensionValueSource: aws.sdk.kotlin.services.sesv2.model.DimensionValueSource = requireNotNull(builder.dimensionValueSource) { "A non-null value must be provided for dimensionValueSource" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.CloudWatchDimensionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchDimensionConfiguration(")
        append("defaultDimensionValue=$defaultDimensionValue,")
        append("dimensionName=$dimensionName,")
        append("dimensionValueSource=$dimensionValueSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultDimensionValue.hashCode()
        result = 31 * result + (dimensionName.hashCode())
        result = 31 * result + (dimensionValueSource.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchDimensionConfiguration

        if (defaultDimensionValue != other.defaultDimensionValue) return false
        if (dimensionName != other.dimensionName) return false
        if (dimensionValueSource != other.dimensionValueSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.CloudWatchDimensionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email. This value has to meet the following criteria:
         * + Can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-), at signs (@), and periods (.).
         * + It can contain no more than 256 characters.
         */
        public var defaultDimensionValue: kotlin.String? = null
        /**
         * The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to meet the following criteria:
         * + It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         * + It can contain no more than 256 characters.
         */
        public var dimensionName: kotlin.String? = null
        /**
         * The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an `X-SES-MESSAGE-TAGS` header or a parameter to the `SendEmail` or `SendRawEmail` API, choose `messageTag`. To use your own email headers, choose `emailHeader`. To use link tags, choose `linkTags`.
         */
        public var dimensionValueSource: aws.sdk.kotlin.services.sesv2.model.DimensionValueSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.CloudWatchDimensionConfiguration) : this() {
            this.defaultDimensionValue = x.defaultDimensionValue
            this.dimensionName = x.dimensionName
            this.dimensionValueSource = x.dimensionValueSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.CloudWatchDimensionConfiguration = CloudWatchDimensionConfiguration(this)

        internal fun correctErrors(): Builder {
            if (defaultDimensionValue == null) defaultDimensionValue = ""
            if (dimensionName == null) dimensionName = ""
            if (dimensionValueSource == null) dimensionValueSource = DimensionValueSource.SdkUnknown("no value provided")
            return this
        }
    }
}
