// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



public class BulkEmailEntry private constructor(builder: Builder) {
    /**
     * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
     *
     * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the local part of a destination email address (the part of the email address that precedes the @ sign) may only contain [7-bit ASCII characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If the domain part of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in [RFC3492](https://tools.ietf.org/html/rfc3492.html).
     */
    public val destination: aws.sdk.kotlin.services.sesv2.model.Destination? = builder.destination
    /**
     * The `ReplacementEmailContent` associated with a `BulkEmailEntry`.
     */
    public val replacementEmailContent: aws.sdk.kotlin.services.sesv2.model.ReplacementEmailContent? = builder.replacementEmailContent
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using the `SendBulkTemplatedEmail` operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
     */
    public val replacementTags: List<MessageTag>? = builder.replacementTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.BulkEmailEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BulkEmailEntry(")
        append("destination=$destination,")
        append("replacementEmailContent=$replacementEmailContent,")
        append("replacementTags=$replacementTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (replacementEmailContent?.hashCode() ?: 0)
        result = 31 * result + (replacementTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BulkEmailEntry

        if (destination != other.destination) return false
        if (replacementEmailContent != other.replacementEmailContent) return false
        if (replacementTags != other.replacementTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.BulkEmailEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
         *
         * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the local part of a destination email address (the part of the email address that precedes the @ sign) may only contain [7-bit ASCII characters](https://en.wikipedia.org/wiki/Email_address#Local-part). If the domain part of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in [RFC3492](https://tools.ietf.org/html/rfc3492.html).
         */
        public var destination: aws.sdk.kotlin.services.sesv2.model.Destination? = null
        /**
         * The `ReplacementEmailContent` associated with a `BulkEmailEntry`.
         */
        public var replacementEmailContent: aws.sdk.kotlin.services.sesv2.model.ReplacementEmailContent? = null
        /**
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the `SendBulkTemplatedEmail` operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
         */
        public var replacementTags: List<MessageTag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.BulkEmailEntry) : this() {
            this.destination = x.destination
            this.replacementEmailContent = x.replacementEmailContent
            this.replacementTags = x.replacementTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.BulkEmailEntry = BulkEmailEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.sesv2.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.sesv2.model.Destination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.ReplacementEmailContent] inside the given [block]
         */
        public fun replacementEmailContent(block: aws.sdk.kotlin.services.sesv2.model.ReplacementEmailContent.Builder.() -> kotlin.Unit) {
            this.replacementEmailContent = aws.sdk.kotlin.services.sesv2.model.ReplacementEmailContent.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
