// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a single metric data query to include in a batch.
 */
public class BatchGetMetricDataQuery private constructor(builder: Builder) {
    /**
     * An object that contains mapping between `MetricDimensionName` and `MetricDimensionValue` to filter metrics by.
     */
    public val dimensions: Map<MetricDimensionName, String>? = builder.dimensions
    /**
     * Represents the end date for the query interval.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endDate) { "A non-null value must be provided for endDate" }
    /**
     * The query identifier.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The queried metric. This can be one of the following:
     * + `SEND` – Emails sent eligible for tracking in the VDM dashboard. This excludes emails sent to the mailbox simulator and emails addressed to more than one recipient.
     * + `COMPLAINT` – Complaints received for your account. This excludes complaints from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient
     * + `PERMANENT_BOUNCE` – Permanent bounces - i.e. feedback received for emails sent to non-existent mailboxes. Excludes bounces from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient.
     * + `TRANSIENT_BOUNCE` – Transient bounces - i.e. feedback received for delivery failures excluding issues with non-existent mailboxes. Excludes bounces from the mailbox simulator, and those for emails addressed to more than one recipient.
     * + `OPEN` – Unique open events for emails including open trackers. Excludes opens for emails addressed to more than one recipient.
     * + `CLICK` – Unique click events for emails including wrapped links. Excludes clicks for emails addressed to more than one recipient.
     * + `DELIVERY` – Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator and for emails addressed to more than one recipient.
     * + `DELIVERY_OPEN` – Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without open trackers.
     * + `DELIVERY_CLICK` – Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without click trackers.
     * + `DELIVERY_COMPLAINT` – Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails addressed to recipients hosted by ISPs with which Amazon SES does not have a feedback loop agreement.
     */
    public val metric: aws.sdk.kotlin.services.sesv2.model.Metric = requireNotNull(builder.metric) { "A non-null value must be provided for metric" }
    /**
     * The query namespace - e.g. `VDM`
     */
    public val namespace: aws.sdk.kotlin.services.sesv2.model.MetricNamespace = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }
    /**
     * Represents the start date for the query interval.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startDate) { "A non-null value must be provided for startDate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.BatchGetMetricDataQuery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetMetricDataQuery(")
        append("dimensions=$dimensions,")
        append("endDate=$endDate,")
        append("id=$id,")
        append("metric=$metric,")
        append("namespace=$namespace,")
        append("startDate=$startDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (endDate.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (metric.hashCode())
        result = 31 * result + (namespace.hashCode())
        result = 31 * result + (startDate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetMetricDataQuery

        if (dimensions != other.dimensions) return false
        if (endDate != other.endDate) return false
        if (id != other.id) return false
        if (metric != other.metric) return false
        if (namespace != other.namespace) return false
        if (startDate != other.startDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.BatchGetMetricDataQuery = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains mapping between `MetricDimensionName` and `MetricDimensionValue` to filter metrics by.
         */
        public var dimensions: Map<MetricDimensionName, String>? = null
        /**
         * Represents the end date for the query interval.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The query identifier.
         */
        public var id: kotlin.String? = null
        /**
         * The queried metric. This can be one of the following:
         * + `SEND` – Emails sent eligible for tracking in the VDM dashboard. This excludes emails sent to the mailbox simulator and emails addressed to more than one recipient.
         * + `COMPLAINT` – Complaints received for your account. This excludes complaints from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient
         * + `PERMANENT_BOUNCE` – Permanent bounces - i.e. feedback received for emails sent to non-existent mailboxes. Excludes bounces from the mailbox simulator, those originating from your account-level suppression list (if enabled), and those for emails addressed to more than one recipient.
         * + `TRANSIENT_BOUNCE` – Transient bounces - i.e. feedback received for delivery failures excluding issues with non-existent mailboxes. Excludes bounces from the mailbox simulator, and those for emails addressed to more than one recipient.
         * + `OPEN` – Unique open events for emails including open trackers. Excludes opens for emails addressed to more than one recipient.
         * + `CLICK` – Unique click events for emails including wrapped links. Excludes clicks for emails addressed to more than one recipient.
         * + `DELIVERY` – Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator and for emails addressed to more than one recipient.
         * + `DELIVERY_OPEN` – Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without open trackers.
         * + `DELIVERY_CLICK` – Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails without click trackers.
         * + `DELIVERY_COMPLAINT` – Successful deliveries for email sending attempts. Excludes deliveries to the mailbox simulator, for emails addressed to more than one recipient, and emails addressed to recipients hosted by ISPs with which Amazon SES does not have a feedback loop agreement.
         */
        public var metric: aws.sdk.kotlin.services.sesv2.model.Metric? = null
        /**
         * The query namespace - e.g. `VDM`
         */
        public var namespace: aws.sdk.kotlin.services.sesv2.model.MetricNamespace? = null
        /**
         * Represents the start date for the query interval.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.BatchGetMetricDataQuery) : this() {
            this.dimensions = x.dimensions
            this.endDate = x.endDate
            this.id = x.id
            this.metric = x.metric
            this.namespace = x.namespace
            this.startDate = x.startDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.BatchGetMetricDataQuery = BatchGetMetricDataQuery(this)

        internal fun correctErrors(): Builder {
            if (endDate == null) endDate = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (metric == null) metric = Metric.SdkUnknown("no value provided")
            if (namespace == null) namespace = MetricNamespace.SdkUnknown("no value provided")
            if (startDate == null) startDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
