// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.services.sesv2.model.Destination
import aws.sdk.kotlin.services.sesv2.model.EmailContent
import aws.sdk.kotlin.services.sesv2.model.ListManagementOptions
import aws.sdk.kotlin.services.sesv2.model.MessageTag
import aws.sdk.kotlin.services.sesv2.model.SendEmailRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendEmailOperationSerializer: HttpSerialize<SendEmailRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendEmailRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/v2/email/outbound-emails"
        }

        val payload = serializeSendEmailOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSendEmailOperationBody(context: ExecutionContext, input: SendEmailRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONFIGURATIONSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationSetName"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Content"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Destination"))
    val EMAILTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EmailTags"))
    val FEEDBACKFORWARDINGEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FeedbackForwardingEmailAddress"))
    val FEEDBACKFORWARDINGEMAILADDRESSIDENTITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FeedbackForwardingEmailAddressIdentityArn"))
    val FROMEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FromEmailAddress"))
    val FROMEMAILADDRESSIDENTITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FromEmailAddressIdentityArn"))
    val LISTMANAGEMENTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ListManagementOptions"))
    val REPLYTOADDRESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReplyToAddresses"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONSETNAME_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(EMAILTAGS_DESCRIPTOR)
        field(FEEDBACKFORWARDINGEMAILADDRESS_DESCRIPTOR)
        field(FEEDBACKFORWARDINGEMAILADDRESSIDENTITYARN_DESCRIPTOR)
        field(FROMEMAILADDRESS_DESCRIPTOR)
        field(FROMEMAILADDRESSIDENTITYARN_DESCRIPTOR)
        field(LISTMANAGEMENTOPTIONS_DESCRIPTOR)
        field(REPLYTOADDRESSES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.configurationSetName?.let { field(CONFIGURATIONSETNAME_DESCRIPTOR, it) }
        input.content?.let { field(CONTENT_DESCRIPTOR, it, ::serializeEmailContentDocument) }
        input.destination?.let { field(DESTINATION_DESCRIPTOR, it, ::serializeDestinationDocument) }
        if (input.emailTags != null) {
            listField(EMAILTAGS_DESCRIPTOR) {
                for (el0 in input.emailTags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMessageTagDocument))
                }
            }
        }
        input.feedbackForwardingEmailAddress?.let { field(FEEDBACKFORWARDINGEMAILADDRESS_DESCRIPTOR, it) }
        input.feedbackForwardingEmailAddressIdentityArn?.let { field(FEEDBACKFORWARDINGEMAILADDRESSIDENTITYARN_DESCRIPTOR, it) }
        input.fromEmailAddress?.let { field(FROMEMAILADDRESS_DESCRIPTOR, it) }
        input.fromEmailAddressIdentityArn?.let { field(FROMEMAILADDRESSIDENTITYARN_DESCRIPTOR, it) }
        input.listManagementOptions?.let { field(LISTMANAGEMENTOPTIONS_DESCRIPTOR, it, ::serializeListManagementOptionsDocument) }
        if (input.replyToAddresses != null) {
            listField(REPLYTOADDRESSES_DESCRIPTOR) {
                for (el0 in input.replyToAddresses) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
