// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.services.sesv2.model.DeliverabilityDashboardAccountStatus
import aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityTrackingOption
import aws.sdk.kotlin.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetDeliverabilityDashboardOptionsOperationDeserializer: HttpDeserialize<GetDeliverabilityDashboardOptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDeliverabilityDashboardOptionsResponse {
        if (!response.status.isSuccess()) {
            throwGetDeliverabilityDashboardOptionsError(context, response)
        }
        val builder = GetDeliverabilityDashboardOptionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDeliverabilityDashboardOptionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDeliverabilityDashboardOptionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeliverabilityDashboardOptionsOperationBody(builder: GetDeliverabilityDashboardOptionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AccountStatus"))
    val ACTIVESUBSCRIBEDDOMAINS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ActiveSubscribedDomains"))
    val DASHBOARDENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DashboardEnabled"))
    val PENDINGEXPIRATIONSUBSCRIBEDDOMAINS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PendingExpirationSubscribedDomains"))
    val SUBSCRIPTIONEXPIRYDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("SubscriptionExpiryDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTSTATUS_DESCRIPTOR)
        field(ACTIVESUBSCRIBEDDOMAINS_DESCRIPTOR)
        field(DASHBOARDENABLED_DESCRIPTOR)
        field(PENDINGEXPIRATIONSUBSCRIBEDDOMAINS_DESCRIPTOR)
        field(SUBSCRIPTIONEXPIRYDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTSTATUS_DESCRIPTOR.index -> builder.accountStatus = deserializeString().let { DeliverabilityDashboardAccountStatus.fromValue(it) }
                ACTIVESUBSCRIBEDDOMAINS_DESCRIPTOR.index -> builder.activeSubscribedDomains =
                    deserializer.deserializeList(ACTIVESUBSCRIBEDDOMAINS_DESCRIPTOR) {
                        val col0 = mutableListOf<DomainDeliverabilityTrackingOption>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDomainDeliverabilityTrackingOptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DASHBOARDENABLED_DESCRIPTOR.index -> builder.dashboardEnabled = deserializeBoolean()
                PENDINGEXPIRATIONSUBSCRIBEDDOMAINS_DESCRIPTOR.index -> builder.pendingExpirationSubscribedDomains =
                    deserializer.deserializeList(PENDINGEXPIRATIONSUBSCRIBEDDOMAINS_DESCRIPTOR) {
                        val col0 = mutableListOf<DomainDeliverabilityTrackingOption>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDomainDeliverabilityTrackingOptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUBSCRIPTIONEXPIRYDATE_DESCRIPTOR.index -> builder.subscriptionExpiryDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
