// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Details about an email identity.
 */
public class GetEmailIdentityResponse private constructor(builder: Builder) {
    /**
     * The configuration set used by default when sending from this identity.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * An object that contains information about the DKIM attributes for the identity.
     */
    public val dkimAttributes: aws.sdk.kotlin.services.sesv2.model.DkimAttributes? = builder.dkimAttributes
    /**
     * The feedback forwarding configuration for the identity.
     *
     * If the value is `true`, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the `Return-Path` header of the original email.
     *
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).
     */
    public val feedbackForwardingStatus: kotlin.Boolean = builder.feedbackForwardingStatus
    /**
     * The email identity type. Note: the `MANAGED_DOMAIN` identity type is not supported.
     */
    public val identityType: aws.sdk.kotlin.services.sesv2.model.IdentityType? = builder.identityType
    /**
     * An object that contains information about the Mail-From attributes for the email identity.
     */
    public val mailFromAttributes: aws.sdk.kotlin.services.sesv2.model.MailFromAttributes? = builder.mailFromAttributes
    /**
     * A map of policy names to policies.
     */
    public val policies: Map<String, String>? = builder.policies
    /**
     * An array of objects that define the tags (keys and values) that are associated with the email identity.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The verification status of the identity. The status can be one of the following:
     * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet been able to verify the identity.
     * + `SUCCESS` – The verification process completed successfully.
     * + `FAILED` – The verification process failed.
     * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the verification status of the identity.
     * + `NOT_STARTED` – The verification process hasn't been initiated for the identity.
     */
    public val verificationStatus: aws.sdk.kotlin.services.sesv2.model.VerificationStatus? = builder.verificationStatus
    /**
     * Specifies whether or not the identity is verified. You can only send email from verified email addresses or domains. For more information about verifying identities, see the [Amazon Pinpoint User Guide](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
     */
    public val verifiedForSendingStatus: kotlin.Boolean = builder.verifiedForSendingStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.GetEmailIdentityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEmailIdentityResponse(")
        append("configurationSetName=$configurationSetName,")
        append("dkimAttributes=$dkimAttributes,")
        append("feedbackForwardingStatus=$feedbackForwardingStatus,")
        append("identityType=$identityType,")
        append("mailFromAttributes=$mailFromAttributes,")
        append("policies=$policies,")
        append("tags=$tags,")
        append("verificationStatus=$verificationStatus,")
        append("verifiedForSendingStatus=$verifiedForSendingStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (dkimAttributes?.hashCode() ?: 0)
        result = 31 * result + (feedbackForwardingStatus.hashCode())
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (mailFromAttributes?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (verificationStatus?.hashCode() ?: 0)
        result = 31 * result + (verifiedForSendingStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEmailIdentityResponse

        if (configurationSetName != other.configurationSetName) return false
        if (dkimAttributes != other.dkimAttributes) return false
        if (feedbackForwardingStatus != other.feedbackForwardingStatus) return false
        if (identityType != other.identityType) return false
        if (mailFromAttributes != other.mailFromAttributes) return false
        if (policies != other.policies) return false
        if (tags != other.tags) return false
        if (verificationStatus != other.verificationStatus) return false
        if (verifiedForSendingStatus != other.verifiedForSendingStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.GetEmailIdentityResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration set used by default when sending from this identity.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * An object that contains information about the DKIM attributes for the identity.
         */
        public var dkimAttributes: aws.sdk.kotlin.services.sesv2.model.DkimAttributes? = null
        /**
         * The feedback forwarding configuration for the identity.
         *
         * If the value is `true`, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the `Return-Path` header of the original email.
         *
         * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).
         */
        public var feedbackForwardingStatus: kotlin.Boolean = false
        /**
         * The email identity type. Note: the `MANAGED_DOMAIN` identity type is not supported.
         */
        public var identityType: aws.sdk.kotlin.services.sesv2.model.IdentityType? = null
        /**
         * An object that contains information about the Mail-From attributes for the email identity.
         */
        public var mailFromAttributes: aws.sdk.kotlin.services.sesv2.model.MailFromAttributes? = null
        /**
         * A map of policy names to policies.
         */
        public var policies: Map<String, String>? = null
        /**
         * An array of objects that define the tags (keys and values) that are associated with the email identity.
         */
        public var tags: List<Tag>? = null
        /**
         * The verification status of the identity. The status can be one of the following:
         * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet been able to verify the identity.
         * + `SUCCESS` – The verification process completed successfully.
         * + `FAILED` – The verification process failed.
         * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the verification status of the identity.
         * + `NOT_STARTED` – The verification process hasn't been initiated for the identity.
         */
        public var verificationStatus: aws.sdk.kotlin.services.sesv2.model.VerificationStatus? = null
        /**
         * Specifies whether or not the identity is verified. You can only send email from verified email addresses or domains. For more information about verifying identities, see the [Amazon Pinpoint User Guide](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
         */
        public var verifiedForSendingStatus: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.GetEmailIdentityResponse) : this() {
            this.configurationSetName = x.configurationSetName
            this.dkimAttributes = x.dkimAttributes
            this.feedbackForwardingStatus = x.feedbackForwardingStatus
            this.identityType = x.identityType
            this.mailFromAttributes = x.mailFromAttributes
            this.policies = x.policies
            this.tags = x.tags
            this.verificationStatus = x.verificationStatus
            this.verifiedForSendingStatus = x.verifiedForSendingStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.GetEmailIdentityResponse = GetEmailIdentityResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.DkimAttributes] inside the given [block]
         */
        public fun dkimAttributes(block: aws.sdk.kotlin.services.sesv2.model.DkimAttributes.Builder.() -> kotlin.Unit) {
            this.dkimAttributes = aws.sdk.kotlin.services.sesv2.model.DkimAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.MailFromAttributes] inside the given [block]
         */
        public fun mailFromAttributes(block: aws.sdk.kotlin.services.sesv2.model.MailFromAttributes.Builder.() -> kotlin.Unit) {
            this.mailFromAttributes = aws.sdk.kotlin.services.sesv2.model.MailFromAttributes.invoke(block)
        }
    }
}
