// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * The result of the `SendBulkEmail` operation of each specified `BulkEmailEntry`.
 */
public class BulkEmailEntryResult private constructor(builder: Builder) {
    /**
     * A description of an error that prevented a message being sent using the `SendBulkTemplatedEmail` operation.
     */
    public val error: kotlin.String? = builder.error
    /**
     * The unique message identifier returned from the `SendBulkTemplatedEmail` operation.
     */
    public val messageId: kotlin.String? = builder.messageId
    /**
     * The status of a message sent using the `SendBulkTemplatedEmail` operation.
     *
     * Possible values for this parameter include:
     * + SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
     * + MESSAGE_REJECTED: The message was rejected because it contained a virus.
     * + MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
     * + CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
     * + TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
     * + ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending practices.
     * + ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded its allocated sending limit.
     * + ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from your account in a 24-hour period.
     * + INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.
     * + ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the [UpdateAccountSendingEnabled](https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html) operation.
     * + CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the [UpdateConfigurationSetSendingEnabled](https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html) operation.
     * + INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was invalid. See the error message for additional information.
     * + TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
     * + FAILED: Amazon SES was unable to process your request. See the error message for additional information.
     */
    public val status: aws.sdk.kotlin.services.sesv2.model.BulkEmailStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.BulkEmailEntryResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BulkEmailEntryResult(")
        append("error=$error,")
        append("messageId=$messageId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = error?.hashCode() ?: 0
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BulkEmailEntryResult

        if (error != other.error) return false
        if (messageId != other.messageId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.BulkEmailEntryResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of an error that prevented a message being sent using the `SendBulkTemplatedEmail` operation.
         */
        public var error: kotlin.String? = null
        /**
         * The unique message identifier returned from the `SendBulkTemplatedEmail` operation.
         */
        public var messageId: kotlin.String? = null
        /**
         * The status of a message sent using the `SendBulkTemplatedEmail` operation.
         *
         * Possible values for this parameter include:
         * + SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.
         * + MESSAGE_REJECTED: The message was rejected because it contained a virus.
         * + MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not verified.
         * + CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.
         * + TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
         * + ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending practices.
         * + ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded its allocated sending limit.
         * + ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from your account in a 24-hour period.
         * + INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.
         * + ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the [UpdateAccountSendingEnabled](https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html) operation.
         * + CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the [UpdateConfigurationSetSendingEnabled](https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html) operation.
         * + INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was invalid. See the error message for additional information.
         * + TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.
         * + FAILED: Amazon SES was unable to process your request. See the error message for additional information.
         */
        public var status: aws.sdk.kotlin.services.sesv2.model.BulkEmailStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.BulkEmailEntryResult) : this() {
            this.error = x.error
            this.messageId = x.messageId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.BulkEmailEntryResult = BulkEmailEntryResult(this)
    }
}
