// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.paginators

import aws.sdk.kotlin.services.sesv2.SesV2Client
import aws.sdk.kotlin.services.sesv2.model.GetDedicatedIpsRequest
import aws.sdk.kotlin.services.sesv2.model.GetDedicatedIpsResponse
import aws.sdk.kotlin.services.sesv2.model.ListConfigurationSetsRequest
import aws.sdk.kotlin.services.sesv2.model.ListConfigurationSetsResponse
import aws.sdk.kotlin.services.sesv2.model.ListContactListsRequest
import aws.sdk.kotlin.services.sesv2.model.ListContactListsResponse
import aws.sdk.kotlin.services.sesv2.model.ListContactsRequest
import aws.sdk.kotlin.services.sesv2.model.ListContactsResponse
import aws.sdk.kotlin.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest
import aws.sdk.kotlin.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
import aws.sdk.kotlin.services.sesv2.model.ListDedicatedIpPoolsRequest
import aws.sdk.kotlin.services.sesv2.model.ListDedicatedIpPoolsResponse
import aws.sdk.kotlin.services.sesv2.model.ListDeliverabilityTestReportsRequest
import aws.sdk.kotlin.services.sesv2.model.ListDeliverabilityTestReportsResponse
import aws.sdk.kotlin.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest
import aws.sdk.kotlin.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse
import aws.sdk.kotlin.services.sesv2.model.ListEmailIdentitiesRequest
import aws.sdk.kotlin.services.sesv2.model.ListEmailIdentitiesResponse
import aws.sdk.kotlin.services.sesv2.model.ListEmailTemplatesRequest
import aws.sdk.kotlin.services.sesv2.model.ListEmailTemplatesResponse
import aws.sdk.kotlin.services.sesv2.model.ListImportJobsRequest
import aws.sdk.kotlin.services.sesv2.model.ListImportJobsResponse
import aws.sdk.kotlin.services.sesv2.model.ListRecommendationsRequest
import aws.sdk.kotlin.services.sesv2.model.ListRecommendationsResponse
import aws.sdk.kotlin.services.sesv2.model.ListSuppressedDestinationsRequest
import aws.sdk.kotlin.services.sesv2.model.ListSuppressedDestinationsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [GetDedicatedIpsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDedicatedIpsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDedicatedIpsResponse]
 */
public fun SesV2Client.getDedicatedIpsPaginated(initialRequest: GetDedicatedIpsRequest): Flow<GetDedicatedIpsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getDedicatedIpsPaginated.getDedicatedIps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetDedicatedIpsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDedicatedIpsResponse]
 */
public fun SesV2Client.getDedicatedIpsPaginated(block: GetDedicatedIpsRequest.Builder.() -> Unit): Flow<GetDedicatedIpsResponse> =
    getDedicatedIpsPaginated(GetDedicatedIpsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListConfigurationSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationSetsResponse]
 */
public fun SesV2Client.listConfigurationSetsPaginated(initialRequest: ListConfigurationSetsRequest): Flow<ListConfigurationSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationSetsPaginated.listConfigurationSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationSetsResponse]
 */
public fun SesV2Client.listConfigurationSetsPaginated(block: ListConfigurationSetsRequest.Builder.() -> Unit): Flow<ListConfigurationSetsResponse> =
    listConfigurationSetsPaginated(ListConfigurationSetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListContactListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContactListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactListsResponse]
 */
public fun SesV2Client.listContactListsPaginated(initialRequest: ListContactListsRequest): Flow<ListContactListsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContactListsPaginated.listContactLists(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListContactListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactListsResponse]
 */
public fun SesV2Client.listContactListsPaginated(block: ListContactListsRequest.Builder.() -> Unit): Flow<ListContactListsResponse> =
    listContactListsPaginated(ListContactListsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListContactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContactsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactsResponse]
 */
public fun SesV2Client.listContactsPaginated(initialRequest: ListContactsRequest): Flow<ListContactsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContactsPaginated.listContacts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListContactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactsResponse]
 */
public fun SesV2Client.listContactsPaginated(block: ListContactsRequest.Builder.() -> Unit): Flow<ListContactsResponse> =
    listContactsPaginated(ListContactsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCustomVerificationEmailTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomVerificationEmailTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomVerificationEmailTemplatesResponse]
 */
public fun SesV2Client.listCustomVerificationEmailTemplatesPaginated(initialRequest: ListCustomVerificationEmailTemplatesRequest): Flow<ListCustomVerificationEmailTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomVerificationEmailTemplatesPaginated.listCustomVerificationEmailTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomVerificationEmailTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomVerificationEmailTemplatesResponse]
 */
public fun SesV2Client.listCustomVerificationEmailTemplatesPaginated(block: ListCustomVerificationEmailTemplatesRequest.Builder.() -> Unit): Flow<ListCustomVerificationEmailTemplatesResponse> =
    listCustomVerificationEmailTemplatesPaginated(ListCustomVerificationEmailTemplatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDedicatedIpPoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDedicatedIpPoolsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDedicatedIpPoolsResponse]
 */
public fun SesV2Client.listDedicatedIpPoolsPaginated(initialRequest: ListDedicatedIpPoolsRequest): Flow<ListDedicatedIpPoolsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDedicatedIpPoolsPaginated.listDedicatedIpPools(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDedicatedIpPoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDedicatedIpPoolsResponse]
 */
public fun SesV2Client.listDedicatedIpPoolsPaginated(block: ListDedicatedIpPoolsRequest.Builder.() -> Unit): Flow<ListDedicatedIpPoolsResponse> =
    listDedicatedIpPoolsPaginated(ListDedicatedIpPoolsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDeliverabilityTestReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeliverabilityTestReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeliverabilityTestReportsResponse]
 */
public fun SesV2Client.listDeliverabilityTestReportsPaginated(initialRequest: ListDeliverabilityTestReportsRequest): Flow<ListDeliverabilityTestReportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeliverabilityTestReportsPaginated.listDeliverabilityTestReports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDeliverabilityTestReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeliverabilityTestReportsResponse]
 */
public fun SesV2Client.listDeliverabilityTestReportsPaginated(block: ListDeliverabilityTestReportsRequest.Builder.() -> Unit): Flow<ListDeliverabilityTestReportsResponse> =
    listDeliverabilityTestReportsPaginated(ListDeliverabilityTestReportsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDomainDeliverabilityCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainDeliverabilityCampaignsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainDeliverabilityCampaignsResponse]
 */
public fun SesV2Client.listDomainDeliverabilityCampaignsPaginated(initialRequest: ListDomainDeliverabilityCampaignsRequest): Flow<ListDomainDeliverabilityCampaignsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainDeliverabilityCampaignsPaginated.listDomainDeliverabilityCampaigns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainDeliverabilityCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainDeliverabilityCampaignsResponse]
 */
public fun SesV2Client.listDomainDeliverabilityCampaignsPaginated(block: ListDomainDeliverabilityCampaignsRequest.Builder.() -> Unit): Flow<ListDomainDeliverabilityCampaignsResponse> =
    listDomainDeliverabilityCampaignsPaginated(ListDomainDeliverabilityCampaignsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEmailIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEmailIdentitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEmailIdentitiesResponse]
 */
public fun SesV2Client.listEmailIdentitiesPaginated(initialRequest: ListEmailIdentitiesRequest): Flow<ListEmailIdentitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEmailIdentitiesPaginated.listEmailIdentities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEmailIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEmailIdentitiesResponse]
 */
public fun SesV2Client.listEmailIdentitiesPaginated(block: ListEmailIdentitiesRequest.Builder.() -> Unit): Flow<ListEmailIdentitiesResponse> =
    listEmailIdentitiesPaginated(ListEmailIdentitiesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEmailTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEmailTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEmailTemplatesResponse]
 */
public fun SesV2Client.listEmailTemplatesPaginated(initialRequest: ListEmailTemplatesRequest): Flow<ListEmailTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEmailTemplatesPaginated.listEmailTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEmailTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEmailTemplatesResponse]
 */
public fun SesV2Client.listEmailTemplatesPaginated(block: ListEmailTemplatesRequest.Builder.() -> Unit): Flow<ListEmailTemplatesResponse> =
    listEmailTemplatesPaginated(ListEmailTemplatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportJobsResponse]
 */
public fun SesV2Client.listImportJobsPaginated(initialRequest: ListImportJobsRequest): Flow<ListImportJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportJobsPaginated.listImportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportJobsResponse]
 */
public fun SesV2Client.listImportJobsPaginated(block: ListImportJobsRequest.Builder.() -> Unit): Flow<ListImportJobsResponse> =
    listImportJobsPaginated(ListImportJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRecommendationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecommendationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendationsResponse]
 */
public fun SesV2Client.listRecommendationsPaginated(initialRequest: ListRecommendationsRequest): Flow<ListRecommendationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecommendationsPaginated.listRecommendations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRecommendationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendationsResponse]
 */
public fun SesV2Client.listRecommendationsPaginated(block: ListRecommendationsRequest.Builder.() -> Unit): Flow<ListRecommendationsResponse> =
    listRecommendationsPaginated(ListRecommendationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSuppressedDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSuppressedDestinationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSuppressedDestinationsResponse]
 */
public fun SesV2Client.listSuppressedDestinationsPaginated(initialRequest: ListSuppressedDestinationsRequest): Flow<ListSuppressedDestinationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSuppressedDestinationsPaginated.listSuppressedDestinations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSuppressedDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSuppressedDestinationsResponse]
 */
public fun SesV2Client.listSuppressedDestinationsPaginated(block: ListSuppressedDestinationsRequest.Builder.() -> Unit): Flow<ListSuppressedDestinationsResponse> =
    listSuppressedDestinationsPaginated(ListSuppressedDestinationsRequest.Builder().apply(block).build())
